/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.pastry;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.id.comparator.AlgoBasedTowardTargetIDAddrComparator;
import ow.id.comparator.AlgoBasedTowardTargetIDComparator;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.Tag;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingContext;
import ow.routing.RoutingService;
import ow.routing.impl.AbstractRoutingAlgorithm;
import ow.routing.pastry.LeafSet;
import ow.routing.pastry.PastryConfiguration;
import ow.routing.pastry.PastryMessageFactory;
import ow.routing.plaxton.Plaxton;
import ow.routing.plaxton.RoutingTableRow;
import ow.util.Timer;

public final class Pastry
extends Plaxton {
    public static Log logger = LogFactory.getLog(Pastry.class);
    private final Message reqLeafSetMessage;
    private PastryConfiguration config;
    private LeafSet leafSet = null;
    private RoutingTableMaintainer routingTableMaintainer;
    private Thread routingTableMaintainerThread = null;
    private final BigInteger ID_SPACE_SIZE = BigInteger.ONE.shiftLeft(this.idSizeInBit);
    private final BigInteger HALF_ID_SPACE_SIZE = BigInteger.ONE.shiftLeft(this.idSizeInBit - 1);

    protected Pastry(RoutingAlgorithmConfiguration conf, RoutingService routingSvc) throws InvalidAlgorithmParameterException {
        super(conf, routingSvc);
        this.config = (PastryConfiguration)conf;
        if (this.config.getUseLeafSet()) {
            if (routingSvc != null) {
                this.leafSet = new LeafSet(this, this.config.getIDSizeInByte() * 8, routingSvc.getSelfIDAddressPair(), this.config.getLeafSetOneSideSize());
            } else {
                logger.fatal("routingSvc is null. test?");
            }
        }
        this.reqLeafSetMessage = PastryMessageFactory.getReqLeafSetMessage(this.selfIDAddress);
        this.prepareHandlers();
    }

    private synchronized void startRoutingTableMaintainer() {
        if (!this.config.getDoPeriodicRoutingTableMaintenance()) {
            return;
        }
        if (this.routingTableMaintainer != null) {
            return;
        }
        this.routingTableMaintainer = new RoutingTableMaintainer();
        if (this.config.getUseTimerInsteadOfThread()) {
            timer.schedule(this.routingTableMaintainer, System.currentTimeMillis(), true, true);
        } else if (this.routingTableMaintainerThread == null) {
            this.routingTableMaintainerThread = new Thread(this.routingTableMaintainer);
            this.routingTableMaintainerThread.setName("RoutingTableMaintainer on " + this.selfIDAddress.getAddress());
            this.routingTableMaintainerThread.setDaemon(true);
            this.routingTableMaintainerThread.start();
        }
    }

    private synchronized void stopRoutingTableMaintainer() {
        if (this.routingTableMaintainerThread != null) {
            this.routingTableMaintainerThread.interrupt();
            this.routingTableMaintainerThread = null;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.leafSet.clear();
    }

    @Override
    public synchronized void stop() {
        super.stop();
        this.stopRoutingTableMaintainer();
    }

    @Override
    public synchronized void suspend() {
        super.suspend();
        this.stopRoutingTableMaintainer();
    }

    @Override
    public synchronized void resume() {
        super.resume();
        this.startRoutingTableMaintainer();
    }

    @Override
    public BigInteger distance(ID to, ID from) {
        BigInteger fromInt;
        BigInteger toInt = to.toBigInteger();
        BigInteger distance = toInt.subtract(fromInt = from.toBigInteger());
        if (distance.compareTo(BigInteger.ZERO) < 0) {
            distance = distance.add(this.ID_SPACE_SIZE);
        }
        if (distance.compareTo(this.HALF_ID_SPACE_SIZE) < 0) {
            distance = distance.shiftLeft(1);
        } else {
            distance = this.ID_SPACE_SIZE.subtract(distance);
            distance = distance.shiftLeft(1);
            distance = distance.subtract(BigInteger.ONE);
        }
        return distance;
    }

    @Override
    public IDAddressPair[] closestTo(ID target, int maxNum, RoutingContext cxt) {
        IDAddressPair p;
        int n;
        IDAddressPair[] iDAddressPairArray;
        SortedSet<IDAddressPair> nodesByLeafSet = null;
        IDAddressPair[] nodesByRoutingTable = null;
        boolean leafSetPreferred = false;
        int num = 0;
        if (this.leafSet != null) {
            nodesByLeafSet = this.leafSet.closestNodes(target, maxNum);
            num = nodesByLeafSet.size();
            IDAddressPair targetIDAddress = IDAddressPair.getIDAddressPair(target, null);
            if (target.equals(this.selfIDAddress.getID()) || this.leafSet.coversWithSmallerSet(targetIDAddress) || this.leafSet.coversWithLargerSet(targetIDAddress)) {
                leafSetPreferred = true;
            }
        }
        if (!leafSetPreferred || num < maxNum) {
            ID headOfRoutingTable;
            ID headOfLeafSet;
            AlgoBasedTowardTargetIDComparator toTargetComparator;
            nodesByRoutingTable = super.closestTo(target, maxNum - num, cxt);
            if (!leafSetPreferred && nodesByLeafSet != null && nodesByLeafSet.size() > 0 && nodesByRoutingTable.length > 0 && (toTargetComparator = new AlgoBasedTowardTargetIDComparator(this, target)).compare(headOfLeafSet = nodesByLeafSet.first().getID(), headOfRoutingTable = nodesByRoutingTable[0].getID()) <= 0) {
                leafSetPreferred = true;
            }
        }
        ArrayList<IDAddressPair> result = new ArrayList<IDAddressPair>();
        if (leafSetPreferred) {
            if (nodesByLeafSet != null) {
                result.addAll(nodesByLeafSet);
            }
            if (nodesByRoutingTable != null) {
                iDAddressPairArray = nodesByRoutingTable;
                n = nodesByRoutingTable.length;
                int toTargetComparator = 0;
                while (toTargetComparator < n) {
                    p = iDAddressPairArray[toTargetComparator];
                    result.add(p);
                    ++toTargetComparator;
                }
            }
        } else {
            if (nodesByRoutingTable != null) {
                iDAddressPairArray = nodesByRoutingTable;
                n = nodesByRoutingTable.length;
                int toTargetComparator = 0;
                while (toTargetComparator < n) {
                    p = iDAddressPairArray[toTargetComparator];
                    result.add(p);
                    ++toTargetComparator;
                }
            }
            if (result.size() < maxNum && nodesByLeafSet != null) {
                result.addAll(nodesByLeafSet);
            }
        }
        num = Math.min(result.size(), maxNum);
        IDAddressPair[] ret = new IDAddressPair[num];
        int i = 0;
        while (i < num) {
            ret[i] = (IDAddressPair)result.get(i);
            ++i;
        }
        return ret;
    }

    @Override
    protected List<IDAddressPair> traverseDownward(int rowIndex, int startingCol, ID target, int maxNum) {
        AlgoBasedTowardTargetIDAddrComparator comparator = new AlgoBasedTowardTargetIDAddrComparator(this, target);
        ArrayList<IDAddressPair> results = new ArrayList<IDAddressPair>();
        this.traverseDownward(results, comparator, rowIndex, startingCol, target, maxNum);
        return results;
    }

    private void traverseDownward(List<IDAddressPair> results, Comparator<IDAddressPair> comparator, int rowIndex, int startingCol, ID target, int maxNum) {
        RoutingTableRow row = this.routingTable.getRow(rowIndex);
        int rowSize = row.size();
        if (this.pickCloseEntry(results, comparator, maxNum, target, row, rowIndex, startingCol, 0)) {
            return;
        }
        int i = 1;
        while (i < rowSize) {
            int colIndex = startingCol + i;
            if (colIndex < rowSize && this.pickCloseEntry(results, comparator, maxNum, target, row, rowIndex, colIndex, 1) || (colIndex = startingCol - i) >= 0 && this.pickCloseEntry(results, comparator, maxNum, target, row, rowIndex, colIndex, -1)) break;
            ++i;
        }
    }

    private void traverseDownwardFromLeftToRight(List<IDAddressPair> results, int rowIndex, ID target, int maxNum) {
        RoutingTableRow row = this.routingTable.getRow(rowIndex);
        int rowSize = row.size();
        int i = 0;
        while (i < rowSize) {
            if (this.pickCloseEntry(results, null, maxNum, target, row, rowIndex, i, 1)) break;
            ++i;
        }
    }

    private void traverseDownwardFromRightToLeft(List<IDAddressPair> results, int rowIndex, ID target, int maxNum) {
        RoutingTableRow row = this.routingTable.getRow(rowIndex);
        int rowSize = row.size();
        int i = rowSize - 1;
        while (i >= 0) {
            if (this.pickCloseEntry(results, null, maxNum, target, row, rowIndex, i, -1)) break;
            --i;
        }
    }

    private boolean pickCloseEntry(List<IDAddressPair> results, Comparator<IDAddressPair> comparator, int maxNum, ID target, RoutingTableRow row, int rowIndex, int colIndex, int exploringSide) {
        IDAddressPair entry = row.get(colIndex);
        if (entry == null) {
            return false;
        }
        if (entry.equals(this.selfIDAddress) && rowIndex + 1 < this.idSizeInDigit) {
            if (exploringSide > 0) {
                this.traverseDownwardFromLeftToRight(results, rowIndex + 1, target, maxNum - results.size());
            } else if (exploringSide < 0) {
                this.traverseDownwardFromRightToLeft(results, rowIndex + 1, target, maxNum - results.size());
            } else {
                this.traverseDownward(results, comparator, rowIndex + 1, colIndex, target, maxNum - results.size());
            }
        }
        results.add(entry);
        return results.size() >= maxNum;
    }

    @Override
    protected List<IDAddressPair> traverseUpward(int rowIndex, int maxNum) {
        ArrayList<IDAddressPair> results = new ArrayList<IDAddressPair>();
        ID selfID = this.selfIDAddress.getID();
        int i = rowIndex - 1;
        block0: while (i >= 0) {
            RoutingTableRow row = this.routingTable.getRow(i);
            int rowSize = row.size();
            int digit = this.getDigit(selfID, i);
            int j = 0;
            while (j < rowSize) {
                IDAddressPair entry;
                int colIndex;
                if (j != 0 && (colIndex = digit + j) < rowSize && (entry = row.get(colIndex)) != null) {
                    results.add(entry);
                    if (results.size() >= maxNum) break block0;
                }
                if ((colIndex = (digit - 1 - j) % rowSize) >= 0 && (entry = row.get(colIndex)) != null) {
                    results.add(entry);
                    if (results.size() >= maxNum) break block0;
                }
                ++j;
            }
            --i;
        }
        return results;
    }

    @Override
    public void join(IDAddressPair joiningNode, IDAddressPair lastHop, boolean isFinalHop) {
        int selfMatchDigits;
        int startRow;
        super.join(joiningNode, lastHop, isFinalHop);
        if (lastHop == null) {
            return;
        }
        if (lastHop.equals(joiningNode)) {
            startRow = 0;
        } else {
            int lastMatchBits = ID.matchLengthFromMSB(lastHop.getID(), joiningNode.getID());
            int lastMatchDigits = lastMatchBits / this.digitSize;
            startRow = lastMatchDigits + 1;
        }
        int selfMatchBits = ID.matchLengthFromMSB(this.selfIDAddress.getID(), joiningNode.getID());
        int endRow = selfMatchDigits = selfMatchBits / this.digitSize;
        if (isFinalHop || endRow >= this.idSizeInDigit) {
            endRow = this.idSizeInDigit - 1;
        }
        if (startRow < this.idSizeInDigit && startRow <= endRow) {
            int rowSetWidth = endRow - startRow + 1;
            Set<IDAddressPair> nodeSet = this.routingTable.getNodes(startRow, rowSetWidth);
            nodeSet.remove(joiningNode);
            IDAddressPair[] nodes = new IDAddressPair[nodeSet.size()];
            nodeSet.toArray(nodes);
            IDAddressPair[] smallerLeafSet = null;
            IDAddressPair[] largerLeafSet = null;
            if (this.leafSet != null && isFinalHop) {
                smallerLeafSet = this.leafSet.getArrayOfSmallerSet(joiningNode);
                largerLeafSet = this.leafSet.getArrayOfLargerSet(joiningNode);
            }
            Message reqMsg = PastryMessageFactory.getUpdateRoutingTableMessage(this.selfIDAddress, nodes, smallerLeafSet, largerLeafSet);
            try {
                this.sender.send(joiningNode.getAddress(), reqMsg);
            }
            catch (IOException e) {
                logger.warn("Failed to send a UPDATE_ROUNTING_TABLE message: " + joiningNode.getAddress(), e);
                this.fail(joiningNode);
            }
        }
    }

    @Override
    public void touch(IDAddressPair from) {
        super.touch(from);
        if (this.leafSet != null) {
            this.leafSet.add(from);
        }
    }

    @Override
    public void forget(IDAddressPair failedNode) {
        super.forget(failedNode);
        if (this.leafSet != null) {
            this.leafSet.remove(failedNode);
            this.checkAndFillLeafSet();
        }
    }

    @Override
    public String getRoutingTableString(int verboseLevel) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.routingTable.toString(verboseLevel));
        if (this.leafSet != null) {
            sb.append("\n");
            sb.append("leaf set: ");
            sb.append(this.leafSet.toString(verboseLevel));
        }
        return sb.toString();
    }

    @Override
    public String getRoutingTableHTMLString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<h4>Plaxton Routing Table</h5>\n");
        sb.append(this.routingTable.toHTMLString());
        if (this.leafSet != null) {
            sb.append("<h4>Leaf Set</h4>");
            sb.append(this.leafSet.toHTMLString());
        }
        return sb.toString();
    }

    private void checkAndFillLeafSet() {
        IDAddressPair largest;
        IDAddressPair smallest;
        if (this.leafSet.coversEntireRing()) {
            return;
        }
        int oneSideSize = this.leafSet.getOneSideSize();
        if (this.leafSet.getNumberOfSmallerNodes() < oneSideSize && (smallest = this.leafSet.getSmallestNode()) != null) {
            this.requestLeafSet(smallest);
        }
        if (this.leafSet.getNumberOfLargerNodes() < oneSideSize && (largest = this.leafSet.getLargestNode()) != null) {
            this.requestLeafSet(largest);
        }
    }

    private void requestLeafSet(IDAddressPair target) {
        IDAddressPair p;
        Message repMsg;
        Message reqMsg = this.reqLeafSetMessage;
        try {
            repMsg = this.sender.sendAndReceive(target.getAddress(), reqMsg);
        }
        catch (IOException e) {
            logger.warn("Failed to send or receive REQ/REP_LEAF_SET message.", e);
            this.fail(target);
            return;
        }
        Serializable[] contents = repMsg.getContents();
        IDAddressPair[] smallerLeafSet = (IDAddressPair[])contents[0];
        IDAddressPair[] largerLeafSet = (IDAddressPair[])contents[1];
        this.leafSet.merge(smallerLeafSet);
        this.leafSet.merge(largerLeafSet);
        IDAddressPair[] iDAddressPairArray = smallerLeafSet;
        int n = smallerLeafSet.length;
        int n2 = 0;
        while (n2 < n) {
            p = iDAddressPairArray[n2];
            this.routingTable.merge(p);
            ++n2;
        }
        iDAddressPairArray = largerLeafSet;
        n = largerLeafSet.length;
        n2 = 0;
        while (n2 < n) {
            p = iDAddressPairArray[n2];
            this.routingTable.merge(p);
            ++n2;
        }
    }

    @Override
    protected void prepareHandlers() {
        super.prepareHandlers();
        MessageHandler handler = new MessageHandler(){

            @Override
            public Message process(Message msg) {
                IDAddressPair p;
                Serializable[] contents = msg.getContents();
                IDAddressPair[] nodes = (IDAddressPair[])contents[0];
                IDAddressPair[] smallerLeafSet = (IDAddressPair[])contents[1];
                IDAddressPair[] largerLeafSet = (IDAddressPair[])contents[2];
                HashSet<IDAddressPair> nodesINotice = new HashSet<IDAddressPair>();
                logger.info("UPDATE_ROUTING_TABLE received: # of nodes: " + nodes.length + " on " + Pastry.this.selfIDAddress.getAddress());
                IDAddressPair[] iDAddressPairArray = nodes;
                int n = nodes.length;
                int n2 = 0;
                while (n2 < n) {
                    p = iDAddressPairArray[n2];
                    Pastry.this.routingTable.merge(p);
                    ++n2;
                }
                nodesINotice.addAll(Pastry.this.routingTable.getNodes(0, Integer.MAX_VALUE));
                if (Pastry.this.leafSet != null) {
                    if (smallerLeafSet != null) {
                        Pastry.this.leafSet.merge(smallerLeafSet);
                    }
                    if (largerLeafSet != null) {
                        Pastry.this.leafSet.merge(largerLeafSet);
                    }
                    Pastry.this.checkAndFillLeafSet();
                    iDAddressPairArray = Pastry.this.leafSet.getArrayOfLargerSet();
                    n = iDAddressPairArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        p = iDAddressPairArray[n2];
                        if (p != null) {
                            nodesINotice.add(p);
                        }
                        ++n2;
                    }
                    iDAddressPairArray = Pastry.this.leafSet.getArrayOfSmallerSet();
                    n = iDAddressPairArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        p = iDAddressPairArray[n2];
                        if (p != null) {
                            nodesINotice.add(p);
                        }
                        ++n2;
                    }
                }
                nodesINotice.remove(Pastry.this.selfIDAddress);
                nodesINotice.remove(msg.getSource());
                for (IDAddressPair node : nodesINotice) {
                    logger.info(Pastry.this.selfIDAddress.getAddress() + " sends a PING msg to " + node.getAddress());
                    try {
                        Pastry.this.runtime.ping(Pastry.this.sender, node);
                    }
                    catch (IOException e) {
                        logger.warn("An IOException thrown while sending JOINED message.", e);
                    }
                }
                return null;
            }
        };
        this.runtime.addMessageHandler(Tag.UPDATE_ROUTING_TABLE.getNumber(), handler);
        handler = new MessageHandler(){

            @Override
            public Message process(Message msg) {
                IDAddressPair[] smallerLeafSet = Pastry.this.leafSet.getArrayOfSmallerSet();
                IDAddressPair[] largerLeafSet = Pastry.this.leafSet.getArrayOfLargerSet();
                Message repMsg = PastryMessageFactory.getRepLeafSetMessage(Pastry.this.selfIDAddress, smallerLeafSet, largerLeafSet);
                return repMsg;
            }
        };
        this.runtime.addMessageHandler(Tag.REQ_LEAF_SET.getNumber(), handler);
        handler = new MessageHandler(){

            @Override
            public Message process(Message msg) {
                Serializable[] contents = msg.getContents();
                int rowIndex = (Integer)contents[0];
                RoutingTableRow receivedRow = (RoutingTableRow)contents[1];
                RoutingTableRow row = Pastry.this.routingTable.getRow(rowIndex);
                row = !row.isEmpty() ? new RoutingTableRow(row) : null;
                Message repMsg = PastryMessageFactory.getRepRoutingTableRowMessage(Pastry.this.selfIDAddress, row);
                Pastry.this.routingTable.merge(receivedRow);
                return repMsg;
            }
        };
        this.runtime.addMessageHandler(Tag.REQ_ROUTING_TABLE_ROW.getNumber(), handler);
    }

    static /* synthetic */ Random access$7() {
        return AbstractRoutingAlgorithm.random;
    }

    static /* synthetic */ Timer access$12() {
        return AbstractRoutingAlgorithm.timer;
    }

    private final class RoutingTableMaintainer
    implements Runnable {
        private int rowIndex = -1;

        private RoutingTableMaintainer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block17: {
                try {
                    if (!Pastry.this.config.getUseTimerInsteadOfThread()) {
                        Thread.sleep(Pastry.this.config.getRoutingTableMaintenanceInterval());
                    }
                    while (true) {
                        if (++this.rowIndex >= Pastry.this.idSizeInDigit) {
                            this.rowIndex = 0;
                        }
                        Pastry pastry = Pastry.this;
                        synchronized (pastry) {
                            if (Pastry.this.stopped || Pastry.this.suspended) {
                                Pastry.this.routingTableMaintainer = null;
                                Pastry.this.routingTableMaintainerThread = null;
                                break block17;
                            }
                        }
                        RoutingTableRow row = null;
                        IDAddressPair target = null;
                        int i = this.rowIndex;
                        block8: while (i < Pastry.this.idSizeInDigit) {
                            row = Pastry.this.routingTable.getRow(this.rowIndex);
                            if (!row.isEmpty()) {
                                int colCandidate = Pastry.access$7().nextInt(1 << Pastry.this.digitSize);
                                target = null;
                                int j = 0;
                                while (j < 1 << Pastry.this.digitSize) {
                                    int index = (colCandidate + j) % (1 << Pastry.this.digitSize);
                                    target = row.get(index);
                                    if (Pastry.this.selfIDAddress.equals(target)) {
                                        target = null;
                                    }
                                    if (target != null) break block8;
                                    ++j;
                                }
                            }
                            ++i;
                        }
                        if (target == null) continue;
                        Message msg = PastryMessageFactory.getReqRoutingTableRowMessage(Pastry.this.selfIDAddress, this.rowIndex, row);
                        Message repMsg = null;
                        try {
                            repMsg = Pastry.this.sender.sendAndReceive(target.getAddress(), msg);
                        }
                        catch (IOException e) {
                            logger.warn("Failed to send or receive a REQ/REP_ROUTING_TABLE_ROW message.", e);
                            Pastry.this.fail(target);
                            continue;
                        }
                        Serializable[] contents = repMsg.getContents();
                        row = (RoutingTableRow)contents[0];
                        logger.info(Pastry.this.selfIDAddress.getAddress() + " received REP_ROUTING_TABLE_ROW: " + (row == null ? "(null)" : row));
                        if (row != null) {
                            Pastry.this.routingTable.merge(row);
                            for (IDAddressPair node : row.getAllNodes()) {
                                Pastry.this.leafSet.add(node);
                            }
                        }
                        this.sleep();
                        if (Pastry.this.config.getUseTimerInsteadOfThread()) break;
                    }
                    return;
                }
                catch (InterruptedException e) {
                    logger.warn("RoutingTableMainainer interrupted and die.", e);
                }
            }
        }

        private void sleep() throws InterruptedException {
            long interval = Pastry.this.config.getRoutingTableMaintenanceInterval();
            double playRatio = Pastry.this.config.getRoutingTableMaintenanceIntervalPlayRatio();
            double pauseRatio = 1.0 - playRatio + playRatio * 2.0 * Pastry.access$7().nextDouble();
            long sleepPeriod = (long)((double)interval * pauseRatio);
            if (Pastry.this.config.getUseTimerInsteadOfThread()) {
                Pastry.access$12().schedule(this, System.currentTimeMillis() + sleepPeriod, true, true);
            } else {
                Thread.sleep(sleepPeriod);
            }
        }
    }
}

