/*
 * Decompiled with CFR 0.152.
 */
package ow.stat;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.Message;
import ow.messaging.MessageSender;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingProvider;
import ow.messaging.Tag;
import ow.stat.StatConfiguration;
import ow.stat.impl.StatMessageFactory;
import ow.tool.util.vizframework.VisualizerMessageFactory;

public final class MessagingReporter {
    public static Log logger = LogFactory.getLog(MessagingReporter.class);
    private final StatConfiguration config;
    private final MessagingProvider provider;
    private final MessageSender sender;
    private final int pingFreq;
    private int notificationCount;
    private int failureCount;

    MessagingReporter(StatConfiguration config, MessagingProvider provider, MessageSender sender) {
        this.config = config;
        this.provider = provider;
        this.sender = sender;
        this.pingFreq = this.config.getPingFrequency();
        this.notificationCount = 0;
        this.failureCount = 0;
    }

    public void notifyStatCollectorOfMessageSent(MessagingAddress dest, Message msg, int msgLen) {
        IDAddressPair self;
        MessagingAddress statCollectorAddress;
        block4: {
            statCollectorAddress = this.provider.getMessagingCollectorAddress();
            if (statCollectorAddress == null) {
                return;
            }
            int tag = msg.getTag();
            if (!Tag.toBeReportedToStatCollector(tag)) {
                return;
            }
            self = msg.getSource();
            Message notifyMsg = StatMessageFactory.getMessageSentMessage(self, self.getAddress(), dest, tag, msgLen);
            try {
                this.sender.send(statCollectorAddress, notifyMsg);
            }
            catch (IOException e) {
                logger.warn("Failed to send a MESSGAGE_SENT message.", e);
                if (!this.failInReporting()) break block4;
                return;
            }
        }
        this.confirmAlive(statCollectorAddress, self);
    }

    public void notifyStatCollectorOfDeletedNode(IDAddressPair self, MessagingAddress failedNode, int tag) {
        MessagingAddress statCollectorAddress;
        block4: {
            statCollectorAddress = this.provider.getMessagingCollectorAddress();
            if (statCollectorAddress == null) {
                return;
            }
            if (!Tag.toBeReportedToStatCollector(tag)) {
                return;
            }
            Message notifyMsg = StatMessageFactory.getDeleteNodeMessage(self, failedNode);
            try {
                this.sender.send(statCollectorAddress, notifyMsg);
            }
            catch (IOException e) {
                logger.warn("Failed to send a DELETE message.", e);
                if (!this.failInReporting()) break block4;
                return;
            }
        }
        this.confirmAlive(statCollectorAddress, self);
    }

    public void notifyStatCollectorOfEmphasizeNode(IDAddressPair self, ID nodeID) {
        MessagingAddress statCollectorAddress;
        block3: {
            statCollectorAddress = this.provider.getMessagingCollectorAddress();
            if (statCollectorAddress == null) {
                return;
            }
            Message msg = VisualizerMessageFactory.getEmphasizeNodeMessage(self, nodeID);
            try {
                this.sender.send(statCollectorAddress, msg);
            }
            catch (IOException e) {
                logger.warn("Failed to send a EMPHASIZE_NODE message.", e);
                if (!this.failInReporting()) break block3;
                return;
            }
        }
        this.confirmAlive(statCollectorAddress, self);
    }

    public void notifyStatCollectorOfMarkedID(IDAddressPair self, ID[] ids, int hint) {
        MessagingAddress statCollectorAddress;
        block3: {
            statCollectorAddress = this.provider.getMessagingCollectorAddress();
            if (statCollectorAddress == null) {
                return;
            }
            Message msg = VisualizerMessageFactory.getMarkIDMessage(self, ids, hint);
            try {
                this.sender.send(statCollectorAddress, msg);
            }
            catch (IOException e) {
                logger.warn("Failed to send a MARK_ID message.", e);
                if (!this.failInReporting()) break block3;
                return;
            }
        }
        this.confirmAlive(statCollectorAddress, self);
    }

    public void notifyStatCollectorOfConnectNodes(IDAddressPair self, ID child, ID parent, int colorHint) {
        MessagingAddress statCollectorAddress;
        block3: {
            statCollectorAddress = this.provider.getMessagingCollectorAddress();
            if (statCollectorAddress == null) {
                return;
            }
            Message msg = StatMessageFactory.getConnectNodesMessage(self, child, parent, colorHint);
            try {
                this.sender.send(statCollectorAddress, msg);
            }
            catch (IOException e) {
                logger.warn("Failed to send a CONNECT_NODES message.", e);
                if (!this.failInReporting()) break block3;
                return;
            }
        }
        this.confirmAlive(statCollectorAddress, self);
    }

    public void notifyStatCollectorOfDisconnectNodes(IDAddressPair self, ID child, ID parent, int colorHint) {
        MessagingAddress statCollectorAddress;
        block3: {
            statCollectorAddress = this.provider.getMessagingCollectorAddress();
            if (statCollectorAddress == null) {
                return;
            }
            Message msg = StatMessageFactory.getDisconnectNodesMessage(self, child, parent, colorHint);
            try {
                this.sender.send(statCollectorAddress, msg);
            }
            catch (IOException e) {
                logger.warn("Failed to send a DISCONNECT_NODES message.", e);
                if (!this.failInReporting()) break block3;
                return;
            }
        }
        this.confirmAlive(statCollectorAddress, self);
    }

    private void confirmAlive(MessagingAddress statCollectorAddress, IDAddressPair self) {
        if (this.provider.isReliable() || ++this.notificationCount % this.pingFreq != 0) {
            return;
        }
        Message pingMessage = StatMessageFactory.getStatPingMessage(self);
        Message ackMessage = null;
        try {
            ackMessage = this.sender.sendAndReceive(statCollectorAddress, pingMessage);
            if (ackMessage.getTag() == Tag.STAT_ACK.getNumber()) {
                this.failureCount = 0;
                return;
            }
        }
        catch (IOException e) {
            logger.warn("STAT_PING failed: " + statCollectorAddress);
        }
        catch (NullPointerException e) {
            logger.warn("A null message returned. The target is not a stat collector?");
        }
        this.failInReporting();
    }

    private boolean failInReporting() {
        boolean toForget = false;
        if (++this.failureCount >= this.config.getNumOfFailuresBeforeForgetCollector()) {
            toForget = true;
            this.failureCount = 0;
        }
        if (toForget) {
            logger.warn("Forget a stat collector.");
            this.provider.setMessagingCollectorAddress(null);
        }
        return toForget;
    }
}

