/*
 * Decompiled with CFR 0.152.
 */
package ow.stat.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.MessageReceiver;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingProvider;
import ow.messaging.Tag;
import ow.stat.MessagingCallback;
import ow.stat.MessagingCallbackExtended;
import ow.stat.MessagingCollector;
import ow.stat.StatConfiguration;
import ow.stat.impl.StatMessageFactory;

public final class MessagingCollectorImpl
implements MessagingCollector {
    private final StatConfiguration config;
    private MessagingProvider provider;
    private MessageReceiver receiver;
    private IDAddressPair selfIDAddress;
    private MessagingCallback callback;
    private final Map<MessagingAddress, ID> idTable = new HashMap<MessagingAddress, ID>();

    public MessagingCollectorImpl(StatConfiguration config) throws Exception {
        this.config = config;
        this.provider = this.config.deriveMessagingProvider();
        this.receiver = this.config.deriveMessageReceiver(this.provider);
        this.selfIDAddress = IDAddressPair.getIDAddressPair(null, this.receiver.getSelfAddress());
    }

    @Override
    public void start(MessagingCallback callback) throws IOException {
        this.callback = callback;
        this.prepareHandlers();
    }

    @Override
    public void stop() {
        if (this.receiver != null) {
            this.receiver.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ID getID(MessagingAddress address) {
        ID id = null;
        Map<MessagingAddress, ID> map = this.idTable;
        synchronized (map) {
            id = this.idTable.get(address);
        }
        return id;
    }

    @Override
    public MessagingProvider getMessagingProvider() {
        return this.provider;
    }

    @Override
    public MessageReceiver getMessageReceiver() {
        return this.receiver;
    }

    private void prepareHandlers() {
        MessageHandler handler = new MessageHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Message process(Message msg) {
                Message ret = null;
                Serializable[] contents = msg.getContents();
                int msgTag = msg.getTag();
                if (msgTag == Tag.STAT_PING.getNumber()) {
                    ret = StatMessageFactory.getStatAckMessage(MessagingCollectorImpl.this.selfIDAddress);
                } else if (msgTag == Tag.MESSAGE_SENT.getNumber()) {
                    MessagingAddress src = (MessagingAddress)contents[0];
                    MessagingAddress dest = (MessagingAddress)contents[1];
                    int tag = (Integer)contents[2];
                    int len = (Integer)contents[3];
                    IDAddressPair source = msg.getSource();
                    MessagingAddress addr = source.getAddress();
                    ID id = source.getID();
                    if (id != null) {
                        Map map = MessagingCollectorImpl.this.idTable;
                        synchronized (map) {
                            ID oldID = (ID)MessagingCollectorImpl.this.idTable.get(addr);
                            if (oldID == null || !oldID.equals(id)) {
                                MessagingCollectorImpl.this.idTable.put(addr, id);
                            }
                        }
                    }
                    MessagingCollectorImpl.this.callback.messageSent(src, dest, tag, len);
                } else if (msgTag == Tag.DELETE_NODE.getNumber()) {
                    MessagingAddress node = (MessagingAddress)contents[0];
                    MessagingCollectorImpl.this.callback.nodeFailed(node);
                } else if (MessagingCollectorImpl.this.callback instanceof MessagingCallbackExtended) {
                    MessagingCallbackExtended cb = (MessagingCallbackExtended)MessagingCollectorImpl.this.callback;
                    if (msgTag == Tag.EMPHASIZE_NODE.getNumber()) {
                        ID nodeID = (ID)contents[0];
                        cb.emphasizeNode(nodeID);
                    } else if (msgTag == Tag.MARK_ID.getNumber()) {
                        ID[] ids = (ID[])contents[0];
                        int hint = (Integer)contents[1];
                        ID[] iDArray = ids;
                        int n = ids.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ID id = iDArray[n2];
                            cb.markID(id, hint);
                            ++n2;
                        }
                    } else if (msgTag == Tag.CONNECT_NODES.getNumber()) {
                        ID from = (ID)contents[0];
                        ID to = (ID)contents[1];
                        int colorHint = (Integer)contents[2];
                        cb.connectNodes(from, to, colorHint);
                    } else if (msgTag == Tag.DISCONNECT_NODES.getNumber()) {
                        ID from = (ID)contents[0];
                        ID to = (ID)contents[1];
                        int colorHint = (Integer)contents[2];
                        cb.disconnectNodes(from, to, colorHint);
                    }
                }
                return ret;
            }
        };
        this.receiver.addHandler(handler);
    }
}

