/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.dhtshell.commands;

import java.io.PrintStream;
import ow.dht.DHT;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

public class SetTTLCommand
implements Command<DHT<String>> {
    private static final String[] NAMES = new String[]{"setttl"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "setttl <ttl>";
    }

    @Override
    public boolean execute(ShellContext<DHT<String>> context) {
        int ttl;
        DHT<String> dht = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 1) {
            out.print("usage: " + this.getHelp() + "\r\n");
            out.flush();
            return false;
        }
        try {
            ttl = Integer.parseInt(args[0]) * 1000;
        }
        catch (NumberFormatException e) {
            out.print("TTL should be an integer: " + args[0] + "\r\n");
            return false;
        }
        dht.setTTLForPut(ttl);
        return false;
    }
}

