/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.emulator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public final class OutputRedirector
implements Runnable {
    BufferedReader in;
    PrintStream out;

    public OutputRedirector(PrintStream out) {
        this.out = out;
    }

    public Thread redirect(InputStream in, String threadName) {
        OutputRedirector r = new OutputRedirector(in, this.out);
        Thread t = new Thread(r);
        t.setName(threadName);
        t.setDaemon(true);
        t.start();
        return t;
    }

    private OutputRedirector(InputStream in, PrintStream out) {
        try {
            this.in = new BufferedReader(new InputStreamReader(in, "US-ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.out = out;
    }

    @Override
    public void run() {
        try {
            String line;
            while ((line = this.in.readLine()) != null) {
                this.out.println(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

