/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.emulator.action;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Collection;
import ow.tool.emulator.EmulatorContext;
import ow.tool.emulator.EmulatorMode;
import ow.tool.emulator.EmulatorTask;

public class HaltTask
extends EmulatorTask {
    private PrintStream out;

    public HaltTask(EmulatorContext cxt, PrintStream out) {
        super(cxt);
        this.out = out;
    }

    public HaltTask(HaltTask task) {
        super(task);
        this.out = task.out;
    }

    public String toString() {
        return "halt";
    }

    @Override
    public EmulatorTask cloneTask() {
        return new HaltTask(this);
    }

    @Override
    public boolean doesExit() {
        return true;
    }

    @Override
    public boolean executedConcurrently() {
        return false;
    }

    @Override
    public void run() {
        if (this.cxt.getEmulatorMode() != EmulatorMode.WORKER) {
            this.out.print("halt\r\n");
        }
        try {
            Collection<Writer> controlPipes = this.cxt.getAllControlPipes();
            for (Writer controlPipe : controlPipes) {
                controlPipe.write("halt\n");
                controlPipe.flush();
            }
        }
        catch (IOException e) {
            this.out.print("An IOException thrown while writing a command into a pipe:\r\n");
            e.printStackTrace(this.out);
        }
        this.cxt.haltSchedulingTimer();
    }
}

