/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.emulator.commands;

import java.io.PrintStream;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import ow.tool.emulator.EmulatorContext;
import ow.tool.emulator.EmulatorMode;
import ow.tool.emulator.EmulatorTask;
import ow.tool.emulator.SchedulableCommand;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

public abstract class AbstractScheduleCommand
implements Command<EmulatorContext> {
    @Override
    public abstract String[] getNames();

    @Override
    public abstract String getHelp();

    abstract void schedule(EmulatorContext var1, long var2, long var4, int var6, EmulatorTask var7, boolean var8);

    @Override
    public boolean execute(ShellContext<EmulatorContext> context) {
        EmulatorContext cxt = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 2) {
            out.println("Usage: " + this.getHelp());
            return !context.isInteractive();
        }
        long startTime = 0L;
        long interval = 0L;
        int times = 1;
        boolean timeIsDifferential = false;
        StringTokenizer st = new StringTokenizer(args[0], ",");
        String timeStr = st.nextToken();
        if (timeStr.startsWith("+")) {
            timeIsDifferential = true;
            timeStr = timeStr.substring(1);
        }
        startTime = this.parseLong(timeStr);
        try {
            interval = this.parseLong(st.nextToken());
            times = 0;
            times = Integer.parseInt(st.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Map<String, Command<EmulatorContext>> commandTable = context.getShellServer().getCommandTable();
        Command<EmulatorContext> command = commandTable.get(args[1]);
        if (command == null) {
            out.println("No such command: " + args[1]);
            return !context.isInteractive();
        }
        SchedulableCommand schedulableCommand = null;
        try {
            schedulableCommand = (SchedulableCommand)command;
        }
        catch (ClassCastException e) {
            out.println("Command is not schedulable: " + args[1]);
            return !context.isInteractive();
        }
        String[] taskArgs = new String[args.length - 2];
        System.arraycopy(args, 2, taskArgs, 0, taskArgs.length);
        context.setArguments(taskArgs);
        EmulatorTask task = null;
        try {
            task = schedulableCommand.getEmulatorTask(context);
        }
        catch (Exception e) {
            out.println("An exception thrown during parsing command: " + args[1]);
            return !context.isInteractive();
        }
        this.schedule(cxt, startTime, interval, times, task, timeIsDifferential);
        if (cxt.getEmulatorMode() != EmulatorMode.WORKER && cxt.getVerboseInParsing()) {
            out.print("schedule: " + schedulableCommand.getNames()[0]);
            int i = 0;
            while (i < taskArgs.length) {
                out.print(" " + taskArgs[i]);
                ++i;
            }
            out.println();
        }
        return false;
    }

    private long parseLong(String str) {
        long ret = (str = str.toLowerCase()).startsWith("inf") ? 0x3FFFFFFFFFFFFFFFL : Long.parseLong(str);
        return ret;
    }
}

