/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.listnodes;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import ow.id.ID;
import ow.messaging.MessageReceiver;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingProvider;
import ow.messaging.util.MessagingUtility;
import ow.stat.NodeCollector;
import ow.stat.NodeCollectorCallback;
import ow.stat.StatConfiguration;
import ow.stat.StatFactory;
import ow.util.HTMLUtil;

public class Main {
    private static final String COMMAND = "owlistnodes";

    private static void usage(String command) {
        System.out.println("usage: " + command + " [-r]" + " [-t UDP|TCP]" + " [-s [<self address>][[:]<port>]" + " <host>[:<port>] [<port>]");
    }

    public static void main(String[] args) throws Exception {
        MessagingAddress contact;
        String optVal;
        boolean printRawForm = false;
        String transport = null;
        String selfAddressAndPort = null;
        Options opts = new Options();
        opts.addOption("h", "help", false, "print help");
        opts.addOption("r", "raw", false, "print nodes in the raw form (hostname:port)");
        opts.addOption("t", "transport", true, "transpoft, UDP or TCP");
        opts.addOption("s", "selfipaddress", true, "self IP address (and port)");
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(opts, args);
        }
        catch (ParseException e) {
            System.out.println("There is an invalid option.");
            e.printStackTrace();
            System.exit(1);
        }
        if (cmd.hasOption('h')) {
            Main.usage(COMMAND);
            System.exit(1);
        }
        if (cmd.hasOption('r')) {
            printRawForm = true;
        }
        if ((optVal = cmd.getOptionValue('t')) != null) {
            transport = optVal;
        }
        if ((optVal = cmd.getOptionValue('s')) != null) {
            selfAddressAndPort = optVal;
        }
        args = cmd.getArgs();
        String contactHostAndPort = null;
        int contactPort = -1;
        if (args.length < 1) {
            Main.usage(COMMAND);
            System.exit(1);
        }
        contactHostAndPort = args[0];
        if (args.length >= 2) {
            contactPort = Integer.parseInt(args[1]);
        }
        StatConfiguration config = StatFactory.getDefaultConfiguration();
        config.setDoUPnPNATTraversal(false);
        if (transport != null) {
            config.setMessagingTransport(transport);
        }
        if (selfAddressAndPort != null) {
            MessagingUtility.HostAndPort hostAndPort = MessagingUtility.parseHostnameAndPort(selfAddressAndPort, config.getSelfPort());
            config.setSelfAddress(hostAndPort.getHostName());
            config.setSelfPort(hostAndPort.getPort());
        }
        MessagingProvider provider = config.deriveMessagingProvider();
        MessageReceiver receiver = config.deriveMessageReceiver(provider);
        try {
            contact = provider.getMessagingAddress(contactHostAndPort, contactPort);
        }
        catch (IllegalArgumentException e) {
            contact = provider.getMessagingAddress(contactHostAndPort, config.getContactPort());
        }
        NodeCollectorCallback cb = printRawForm ? new NodeCollectorCallback(){

            @Override
            public void addNode(ID id, MessagingAddress address) {
                System.out.println(new MessagingUtility.HostAndPort(address.getHostname(), address.getPort()));
            }

            @Override
            public void removeNode(ID id) {
            }
        } : new NodeCollectorCallback(){

            @Override
            public void addNode(ID id, MessagingAddress address) {
                System.out.println(HTMLUtil.convertMessagingAddressToURL(address));
            }

            @Override
            public void removeNode(ID id) {
            }
        };
        NodeCollector collector = StatFactory.getNodeCollector(config, contact, cb, receiver);
        collector.investigate();
        receiver.stop();
    }
}

