/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.mcastshell;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.mcast.Mcast;
import ow.mcast.McastCallback;
import ow.mcast.SpanningTreeChangedCallback;
import ow.messaging.util.AccessController;
import ow.tool.emulator.EmulatorControllable;
import ow.tool.mcastshell.commands.ClearCommand;
import ow.tool.mcastshell.commands.GroupsCommand;
import ow.tool.mcastshell.commands.HaltCommand;
import ow.tool.mcastshell.commands.HelpCommand;
import ow.tool.mcastshell.commands.InitCommand;
import ow.tool.mcastshell.commands.JoinCommand;
import ow.tool.mcastshell.commands.LeaveCommand;
import ow.tool.mcastshell.commands.LeaveallCommand;
import ow.tool.mcastshell.commands.MulticastCommand;
import ow.tool.mcastshell.commands.NeighborsCommand;
import ow.tool.mcastshell.commands.QuitCommand;
import ow.tool.mcastshell.commands.ResumeCommand;
import ow.tool.mcastshell.commands.StatusCommand;
import ow.tool.mcastshell.commands.SuspendCommand;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.Interruptible;
import ow.tool.util.shellframework.MessagePrinter;
import ow.tool.util.shellframework.Shell;
import ow.tool.util.shellframework.ShellServer;
import ow.tool.util.toolframework.AbstractMcastBasedTool;

public final class Main
extends AbstractMcastBasedTool
implements EmulatorControllable,
Interruptible {
    private static final String COMMAND = "owmcastshell";
    private static final int SHELL_PORT = -1;
    private static final Class[] COMMANDS = new Class[]{StatusCommand.class, InitCommand.class, JoinCommand.class, LeaveCommand.class, LeaveallCommand.class, MulticastCommand.class, GroupsCommand.class, NeighborsCommand.class, HelpCommand.class, QuitCommand.class, HaltCommand.class, ClearCommand.class, SuspendCommand.class, ResumeCommand.class};
    private static final List<Command<Mcast>> commandList = ShellServer.createCommandList(COMMANDS);
    private static final Map<String, Command<Mcast>> commandTable = ShellServer.createCommandTable(commandList);
    private Thread mainThread = null;

    @Override
    protected void usage(String command) {
        super.usage(command, "[-p <shell port>] [--acl <ACL file>] [-n]");
    }

    public static void main(String[] args) {
        new Main().start(args);
    }

    protected void start(String[] args) {
        Shell<Mcast> stdioShell = null;
        stdioShell = this.init(args, System.in, System.out, true);
        if (stdioShell != null) {
            stdioShell.run();
        }
    }

    @Override
    public Writer invoke(String[] args, PrintStream out) {
        Shell<Mcast> stdioShell = this.init(args, null, out, false);
        if (stdioShell != null) {
            return stdioShell.getWriter();
        }
        return null;
    }

    private Shell<Mcast> init(String[] args, InputStream in, PrintStream out, boolean interactive) {
        int shellPort = -1;
        AccessController ac = null;
        boolean disableStdin = false;
        this.mainThread = Thread.currentThread();
        Options opts = this.getInitialOptions();
        opts.addOption("p", "port", true, "port number");
        opts.addOption("A", "acl", true, "access control list file");
        opts.addOption("n", "disablestdin", false, "disable standard input");
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(opts, args);
        }
        catch (ParseException e) {
            System.out.println("There is an invalid option.");
            e.printStackTrace();
            System.exit(1);
        }
        parser = null;
        opts = null;
        String optVal = cmd.getOptionValue('p');
        if (optVal != null) {
            shellPort = Integer.parseInt(optVal);
        }
        if ((optVal = cmd.getOptionValue("A")) != null) {
            try {
                ac = new AccessController(optVal);
            }
            catch (IOException e) {
                System.err.println("An Exception thrown:");
                e.printStackTrace();
                return null;
            }
        }
        if (cmd.hasOption('n')) {
            disableStdin = true;
        }
        Mcast mcast = null;
        try {
            mcast = super.initialize((short)2, (short)1, COMMAND, cmd);
        }
        catch (Exception e) {
            System.err.println("An Exception thrown:");
            e.printStackTrace();
            return null;
        }
        cmd = null;
        ShellServer<Mcast> shellServ = new ShellServer<Mcast>(commandTable, commandList, new ShowPromptPrinter(), new NoCommandPrinter(), null, mcast, shellPort, ac);
        shellServ.addInterruptible(this);
        Main.prepareMessageReceiver(mcast, shellServ);
        Main.prepareSpanningTreeChangeObserver(mcast, shellServ);
        Shell<Mcast> stdioShell = null;
        if (disableStdin) {
            try {
                Thread.sleep(Long.MAX_VALUE);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            stdioShell = new Shell<Mcast>(in, out, shellServ, mcast, interactive);
        }
        return stdioShell;
    }

    private static void prepareMessageReceiver(Mcast mcast, final ShellServer<Mcast> shellServ) {
        McastCallback msgReceiver = new McastCallback(){

            @Override
            public void received(ID groupID, Serializable payload) {
                shellServ.println("Message to group " + groupID + ":\n" + payload);
            }
        };
        mcast.addMulticastCallback(msgReceiver);
    }

    private static void prepareSpanningTreeChangeObserver(Mcast mcast, final ShellServer<Mcast> shellServ) {
        SpanningTreeChangedCallback callback = new SpanningTreeChangedCallback(){

            @Override
            public void topologyChanged(ID groupID, IDAddressPair parent, IDAddressPair[] children) {
                StringBuilder sb = new StringBuilder();
                sb.append("Spanning tree changed:");
                sb.append("\n group ID: ");
                sb.append(groupID);
                sb.append("\n parent:   ");
                if (parent != null) {
                    sb.append(parent.getAddress());
                } else {
                    sb.append("NONE");
                }
                sb.append("\n children:");
                if (children != null) {
                    IDAddressPair[] iDAddressPairArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDAddressPair p = iDAddressPairArray[n2];
                        if (p != null) {
                            sb.append(" ").append(p.getAddress());
                        }
                        ++n2;
                    }
                } else {
                    sb.append(" NONE");
                }
                shellServ.println(sb.toString());
            }
        };
        mcast.addSpanningTreeChangedCallback(callback);
    }

    @Override
    public void interrupt() {
        if (this.mainThread != null && !this.mainThread.equals(Thread.currentThread())) {
            this.mainThread.interrupt();
        }
    }

    private static class NoCommandPrinter
    implements MessagePrinter {
        private NoCommandPrinter() {
        }

        @Override
        public void execute(PrintStream out, String hint) {
            out.print("No such command");
            if (hint != null) {
                out.print(": " + hint);
            } else {
                out.print(".");
            }
            out.print("\r\n");
            out.flush();
        }
    }

    private static class ShowPromptPrinter
    implements MessagePrinter {
        private ShowPromptPrinter() {
        }

        @Override
        public void execute(PrintStream out, String hint) {
            out.print("Ready.\r\n");
            out.flush();
        }
    }
}

