/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.memcached.commands;

import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import ow.dht.ValueInfo;
import ow.dht.memcached.Item;
import ow.dht.memcached.Memcached;
import ow.id.ID;
import ow.id.IDUtility;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

abstract class AbstractGetCommand
implements Command<Memcached> {
    AbstractGetCommand() {
    }

    protected boolean get(ShellContext<Memcached> context, boolean returnCasUnique) {
        Memcached dht = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 1) {
            out.print("ERROR\r\n");
            out.flush();
            return false;
        }
        ID[] keys = new ID[args.length];
        int i = 0;
        while (i < args.length) {
            keys[i] = IDUtility.parseID(args[i], dht.getRoutingAlgorithmConfiguration().getIDSizeInByte());
            ++i;
        }
        Set<ValueInfo<V>>[] values = dht.get(keys);
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        while (i2 < args.length) {
            if (values[i2] != null && !values[i2].isEmpty()) {
                for (ValueInfo v : values[i2]) {
                    Item item = (Item)v.getValue();
                    sb.append("VALUE ").append(args[i2]);
                    sb.append(" ").append(item.getFlag());
                    sb.append(" ").append(item.getData().length);
                    if (returnCasUnique) {
                        long casUnique = item.hashCode();
                        if (casUnique < 0L) {
                            casUnique += 0x100000000L;
                        }
                        sb.append(" ").append(casUnique);
                    }
                    sb.append("\r\n");
                    try {
                        sb.append(new String(item.getData(), "ASCII"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    sb.append("\r\n");
                }
            }
            ++i2;
        }
        sb.append("END").append("\r\n");
        out.print(sb);
        out.flush();
        return false;
    }
}

