/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.mrouted;

import java.io.IOException;
import java.net.Inet4Address;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ow.id.ID;
import ow.ipmulticast.Group;
import ow.ipmulticast.Host;
import ow.ipmulticast.IPMulticast;
import ow.ipmulticast.VirtualInterface;
import ow.ipmulticast.igmpd.GroupChangeCallback;
import ow.ipmulticast.igmpd.IGMPDaemon;
import ow.mcast.Mcast;
import ow.routing.RoutingException;
import ow.tool.mrouted.ApplicationLevelMulticastRouterConfiguration;
import ow.tool.mrouted.GroupTable;
import ow.tool.mrouted.OverlayTrafficForwarder;

public final class MulticastGroupObserver
implements GroupChangeCallback {
    public static Log logger = LogFactory.getLog(MulticastGroupObserver.class);
    private ApplicationLevelMulticastRouterConfiguration config;
    private Mcast mcast;
    private GroupTable groupTable;
    private final IGMPDaemon igmpd;
    private final IPMulticast ipmcast;
    private final int idSizeInByte;

    MulticastGroupObserver(ApplicationLevelMulticastRouterConfiguration config, Mcast gm, GroupTable groupTable, IGMPDaemon igmpd, IPMulticast mcast, int idSizeInByte) throws IOException {
        this.config = config;
        this.mcast = gm;
        this.groupTable = groupTable;
        this.igmpd = igmpd;
        this.ipmcast = mcast;
        this.idSizeInByte = idSizeInByte;
        SelfMembershipExpiringDaemon r = new SelfMembershipExpiringDaemon();
        Thread t = new Thread(r);
        t.setName("SelfMembershipExpiringDaemon");
        t.setDaemon(true);
        t.start();
    }

    @Override
    public void included(Set<Group> includedGroupSet, VirtualInterface vif) {
        for (Group group : includedGroupSet) {
            ID id = this.groupTable.registerMulticastGroup(group);
            try {
                this.mcast.joinGroup(id);
            }
            catch (RoutingException e) {
                logger.warn("Routing failed.", e);
            }
        }
        for (Group group : includedGroupSet) {
            Inet4Address addr = group.getGroupAddress();
            if (!addr.isMulticastAddress()) continue;
            this.ipmcast.joinGroup(addr, vif);
        }
        this.logGroups("Multicast groups (possibly increased):");
    }

    @Override
    public void excluded(Set<Group> excludedGroupSet, VirtualInterface vif) {
        for (Group group : excludedGroupSet) {
            ID id = this.groupTable.unregisterMulticastGroup(group);
            this.mcast.leaveGroup(id);
        }
        for (Group group : excludedGroupSet) {
            Inet4Address addr = group.getGroupAddress();
            if (!addr.isMulticastAddress()) continue;
            this.ipmcast.leaveGroup(addr, vif);
        }
        this.logGroups("Multicast groups (possibly decreased):");
    }

    private void logGroups(String header) {
        StringBuffer sb = new StringBuffer();
        sb.append(header);
        Group[] groups = this.groupTable.getJoinedGroupSet();
        if (groups == null) {
            sb.append(" NONE");
        } else {
            Group[] groupArray = groups;
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                Group g = groupArray[n2];
                sb.append(" ");
                sb.append(g.getGroupAddress());
                ++n2;
            }
        }
    }

    private final class SelfMembershipExpiringDaemon
    implements Runnable {
        private SelfMembershipExpiringDaemon() {
        }

        @Override
        public void run() {
            block2: while (true) {
                Group[] groups;
                try {
                    Thread.sleep(MulticastGroupObserver.this.config.getSelfMembershipExpCheckInterval());
                }
                catch (InterruptedException e) {
                    logger.info("SelfMembershipExpiringDaemon interrupted.", e);
                    break;
                }
                Group[] groupArray = groups = MulticastGroupObserver.this.groupTable.getJoinedGroupSet();
                int n = groups.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block2;
                    Group group = groupArray[n2];
                    if (group.numOfHosts() == 1) {
                        Inet4Address groupAddress = group.getGroupAddress();
                        long groupMembershipInterval = MulticastGroupObserver.this.igmpd.getGroupMembershipInterval();
                        for (Host h : group.getAllHost()) {
                            OverlayTrafficForwarder forwarder;
                            if (!h.isSelf() || (forwarder = MulticastGroupObserver.this.groupTable.getOverlayTrafficForwarder(ID.getHashcodeBasedID(group.getGroupAddress(), MulticastGroupObserver.this.idSizeInByte))) == null) continue;
                            long lastReceived = forwarder.getLoopbackMessageReceivedTime();
                            long now = System.currentTimeMillis();
                            if (now <= lastReceived + groupMembershipInterval) continue;
                            ID id = MulticastGroupObserver.this.groupTable.unregisterMulticastGroup(group);
                            MulticastGroupObserver.this.mcast.leaveGroup(id);
                            MulticastGroupObserver.this.ipmcast.leaveGroup(groupAddress, group.getVirtualInterface());
                        }
                    }
                    ++n2;
                }
                break;
            }
        }
    }
}

