/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.mrouted;

import java.net.Inet4Address;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ow.tool.mrouted.DecodedMessageOnOverlay;

final class ProtocolOnOverlay {
    public static Log logger = LogFactory.getLog(ProtocolOnOverlay.class);
    public static final int HEADER_LEN = 22;
    public static final int SRC_ADDR_OFFSET = 0;
    public static final int SRC_PORT_OFFSET = 4;
    public static final int DEST_ADDR_OFFSET = 6;
    public static final int DEST_PORT_OFFSET = 10;
    public static final int ID_OFFSET = 12;
    public static final int IP_TTL_OFFSET = 14;
    public static final int OVERLAY_TTL_OFFSET = 16;
    public static final int DATA_LEN_OFFSET = 18;

    ProtocolOnOverlay() {
    }

    static int getHeaderLen() {
        return 22;
    }

    static int encode(byte[] encoded, Inet4Address srcAddr, int srcPort, Inet4Address destAddr, int destPort, int id, int ipTTL, int overlayTTL, byte[] data) {
        ProtocolOnOverlay.setSrcAddress(encoded, srcAddr);
        ProtocolOnOverlay.setDestAddress(encoded, destAddr);
        ProtocolOnOverlay.setSrcPort(encoded, srcPort);
        ProtocolOnOverlay.setDestPort(encoded, destPort);
        ProtocolOnOverlay.setID(encoded, id);
        ProtocolOnOverlay.setIPTTL(encoded, ipTTL);
        ProtocolOnOverlay.setOverlayTTL(encoded, overlayTTL);
        int dataLen = data.length;
        encoded[18] = (byte)(dataLen >> 24);
        encoded[19] = (byte)(dataLen >> 16);
        encoded[20] = (byte)(dataLen >> 8);
        encoded[21] = (byte)dataLen;
        int copyLen = Math.min(dataLen, encoded.length - 22);
        System.arraycopy(data, 0, encoded, 22, copyLen);
        return 22 + copyLen;
    }

    static int decode(DecodedMessageOnOverlay decoded, byte[] encoded) {
        Inet4Address srcAddr = ProtocolOnOverlay.getSrcAddress(encoded);
        Inet4Address destAddr = ProtocolOnOverlay.getDestAddress(encoded);
        int srcPort = ProtocolOnOverlay.getSrcPort(encoded);
        int destPort = ProtocolOnOverlay.getDestPort(encoded);
        int id = ProtocolOnOverlay.getID(encoded);
        int ipTTL = ProtocolOnOverlay.getIPTTL(encoded);
        int overlayTTL = ProtocolOnOverlay.getOverlayTTL(encoded);
        int dataLen = 0;
        dataLen |= (encoded[18] & 0xFF) << 24;
        dataLen |= (encoded[19] & 0xFF) << 16;
        dataLen |= (encoded[20] & 0xFF) << 8;
        dataLen |= encoded[21] & 0xFF;
        byte[] buf = decoded.getData();
        int bufLen = 0;
        if (buf == null) {
            bufLen = Math.min(dataLen, 16384);
            buf = new byte[bufLen];
        } else {
            bufLen = buf.length;
        }
        int copyLen = Math.min(bufLen, dataLen);
        copyLen = Math.min(copyLen, encoded.length - 22);
        if (copyLen != dataLen) {
            logger.warn("Received data have been trimmed from " + dataLen + " byte to " + copyLen + ".");
        }
        System.arraycopy(encoded, 22, buf, 0, copyLen);
        decoded.setSrcAddress(srcAddr);
        decoded.setDestAddress(destAddr);
        decoded.setSrcPort(srcPort);
        decoded.setDestPort(destPort);
        decoded.setID(id);
        decoded.setIPTTL(ipTTL);
        decoded.setOverlayTTL(overlayTTL);
        decoded.setData(buf);
        decoded.setDataLength(copyLen);
        return copyLen;
    }

    static int getID(byte[] encoded) {
        return ProtocolOnOverlay.getUnsignedInt16(encoded, 12);
    }

    static void setID(byte[] encoded, int id) {
        ProtocolOnOverlay.setUnsignedInt16(encoded, 12, id);
    }

    static int getIPTTL(byte[] encoded) {
        return ProtocolOnOverlay.getUnsignedInt16(encoded, 14);
    }

    static void setIPTTL(byte[] encoded, int ttl) {
        ProtocolOnOverlay.setUnsignedInt16(encoded, 14, ttl);
    }

    static int getOverlayTTL(byte[] encoded) {
        return ProtocolOnOverlay.getUnsignedInt16(encoded, 16);
    }

    static void setOverlayTTL(byte[] encoded, int ttl) {
        ProtocolOnOverlay.setUnsignedInt16(encoded, 16, ttl);
    }

    static Inet4Address getSrcAddress(byte[] encoded) {
        return ProtocolOnOverlay.getAddress(encoded, 0);
    }

    static Inet4Address getDestAddress(byte[] encoded) {
        return ProtocolOnOverlay.getAddress(encoded, 6);
    }

    static void setSrcAddress(byte[] encoded, Inet4Address addr) {
        ProtocolOnOverlay.setAddress(encoded, 0, addr);
    }

    static void setDestAddress(byte[] encoded, Inet4Address addr) {
        ProtocolOnOverlay.setAddress(encoded, 6, addr);
    }

    static int getSrcPort(byte[] encoded) {
        return ProtocolOnOverlay.getUnsignedInt16(encoded, 4);
    }

    static int getDestPort(byte[] encoded) {
        return ProtocolOnOverlay.getUnsignedInt16(encoded, 10);
    }

    static void setSrcPort(byte[] encoded, int port) {
        ProtocolOnOverlay.setUnsignedInt16(encoded, 4, port);
    }

    static void setDestPort(byte[] encoded, int port) {
        ProtocolOnOverlay.setUnsignedInt16(encoded, 10, port);
    }

    private static Inet4Address getAddress(byte[] encoded, int offset) {
        byte[] bytes = new byte[4];
        System.arraycopy(encoded, offset, bytes, 0, 4);
        Inet4Address addr = null;
        try {
            addr = (Inet4Address)Inet4Address.getByAddress(bytes);
        }
        catch (UnknownHostException e) {
            logger.warn("An UnknownHostException thrown.", e);
        }
        return addr;
    }

    private static void setAddress(byte[] encoded, int offset, Inet4Address addr) {
        byte[] bytes = addr.getAddress();
        System.arraycopy(bytes, 0, encoded, offset, 4);
    }

    private static int getUnsignedInt16(byte[] encoded, int offset) {
        int result = 0;
        result |= (encoded[offset] & 0xFF) << 8;
        return result |= encoded[offset + 1] & 0xFF;
    }

    private static void setUnsignedInt16(byte[] encoded, int offset, int value) {
        encoded[offset] = (byte)(value >> 8);
        encoded[offset + 1] = (byte)value;
    }
}

