/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.mrouted.commands;

import java.io.PrintStream;
import ow.id.ID;
import ow.ipmulticast.Group;
import ow.ipmulticast.Host;
import ow.tool.mrouted.ApplicationLevelMulticastRouter;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

public final class GroupsCommand
implements Command<ApplicationLevelMulticastRouter> {
    private static final String[] NAMES = new String[]{"groups"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "groups";
    }

    @Override
    public boolean execute(ShellContext<ApplicationLevelMulticastRouter> context) {
        ApplicationLevelMulticastRouter almRouter = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        Group[] groups = almRouter.getJoinedMulticastGroups();
        StringBuilder sb = new StringBuilder();
        sb.append("groups:");
        if (groups != null) {
            Group[] groupArray = groups;
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                Group g = groupArray[n2];
                sb.append("\n ");
                sb.append(g.getGroupAddress());
                sb.append("\t");
                sb.append(ID.getHashcodeBasedID(g.getGroupAddress(), almRouter.getRoutingAlgorithmConfiguration().getIDSizeInByte()));
                if (g.numOfHosts() > 0) {
                    sb.append("\n  ");
                }
                for (Host h : g.getAllHost()) {
                    sb.append(" ");
                    sb.append(h.getAddress());
                }
                ++n2;
            }
        }
        sb.append("\n");
        out.print(sb);
        out.flush();
        return false;
    }
}

