/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.msgcounter;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import ow.messaging.util.AccessController;
import ow.tool.emulator.EmulatorControllable;
import ow.tool.msgcounter.MessageCounter;
import ow.tool.msgcounter.commands.HaltCommand;
import ow.tool.msgcounter.commands.HelpCommand;
import ow.tool.msgcounter.commands.QuitCommand;
import ow.tool.msgcounter.commands.StatusCommand;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.MessagePrinter;
import ow.tool.util.shellframework.Shell;
import ow.tool.util.shellframework.ShellServer;

public final class Main
implements EmulatorControllable {
    private static final String COMMAND = "owmsgcounter";
    private final int DEFAULT_SHELL_PORT = -1;
    private static final Class[] COMMANDS = new Class[]{StatusCommand.class, HelpCommand.class, QuitCommand.class, HaltCommand.class};
    private static final List<Command<MessageCounter>> commandList = ShellServer.createCommandList(COMMANDS);
    private static final Map<String, Command<MessageCounter>> commandTable = ShellServer.createCommandTable(commandList);

    protected void usage(String command) {
        System.out.println("Usage: " + command + " [-p <shell port>] [--acl <ACL file>] [-t UDP|TCP] [--no-upnp]");
    }

    public static void main(String[] args) {
        new Main().start(args);
    }

    protected void start(String[] args) {
        Shell<MessageCounter> stdioShell = null;
        stdioShell = this.init(args, System.in, System.out, true);
        if (stdioShell != null) {
            stdioShell.run();
        }
    }

    @Override
    public Writer invoke(String[] args, PrintStream out) {
        Shell<MessageCounter> stdioShell = this.init(args, null, out, false);
        if (stdioShell != null) {
            return stdioShell.getWriter();
        }
        return null;
    }

    private Shell<MessageCounter> init(String[] args, InputStream in, PrintStream out, boolean interactive) {
        String optVal;
        String transport = null;
        int shellPort = -1;
        AccessController ac = null;
        boolean noUPnP = false;
        Options opts = new Options();
        opts.addOption("h", "help", false, "print help");
        opts.addOption("p", "port", true, "port number");
        opts.addOption("A", "acl", true, "access control list file");
        opts.addOption("t", "transport", true, "transport, UDP or TCP");
        opts.addOption("N", "no-upnp", false, "disable UPnP address port mapping");
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(opts, args);
        }
        catch (ParseException e) {
            System.out.println("There is an invalid option.");
            e.printStackTrace();
            System.exit(1);
        }
        if (cmd.hasOption('h')) {
            this.usage(COMMAND);
            System.exit(1);
        }
        if ((optVal = cmd.getOptionValue('p')) != null) {
            shellPort = Integer.parseInt(optVal);
        }
        if ((optVal = cmd.getOptionValue("A")) != null) {
            try {
                ac = new AccessController(optVal);
            }
            catch (IOException e) {
                System.err.println("An Exception thrown:");
                e.printStackTrace();
                return null;
            }
        }
        if ((optVal = cmd.getOptionValue('t')) != null) {
            transport = optVal;
        }
        if (cmd.hasOption('N')) {
            noUPnP = true;
        }
        args = cmd.getArgs();
        MessageCounter msgCounter = new MessageCounter(transport, noUPnP);
        try {
            msgCounter.start();
        }
        catch (Exception e) {
            System.err.println("An Exception thrown:");
            e.printStackTrace();
            return null;
        }
        ShowPromptPrinter showPromptPrinter = new ShowPromptPrinter();
        NoCommandPrinter noCommandPrinter = new NoCommandPrinter();
        if (shellPort >= 0 && shellPort < 65536) {
            ShellServer<MessageCounter> shellServer = new ShellServer<MessageCounter>(commandTable, commandList, showPromptPrinter, noCommandPrinter, null, msgCounter, shellPort, ac);
        }
        Shell<MessageCounter> stdioShell = new Shell<MessageCounter>(in, out, commandTable, commandList, interactive ? showPromptPrinter : null, noCommandPrinter, null, msgCounter, interactive);
        return stdioShell;
    }

    private static class NoCommandPrinter
    implements MessagePrinter {
        private NoCommandPrinter() {
        }

        @Override
        public void execute(PrintStream out, String hint) {
            out.print("No such command");
            if (hint != null) {
                out.print(": " + hint);
            } else {
                out.print(".");
            }
            out.print("\r\n");
            out.flush();
        }
    }

    private static class ShowPromptPrinter
    implements MessagePrinter {
        private ShowPromptPrinter() {
        }

        @Override
        public void execute(PrintStream out, String hint) {
            out.print("Ready.\r\n");
            out.flush();
        }
    }
}

