/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.msgcounter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import ow.messaging.MessagingAddress;
import ow.messaging.Tag;
import ow.stat.MessagingCallback;
import ow.stat.MessagingCollector;
import ow.stat.StatConfiguration;
import ow.stat.StatFactory;
import ow.tool.msgcounter.NumberAndLengthCounter;

public class MessageCounter
implements MessagingCallback {
    private final StatConfiguration config;
    private MessagingCollector statCollector = null;
    private final Map<Integer, NumberAndLengthCounter> totalCounterMap = new HashMap<Integer, NumberAndLengthCounter>();
    private final Map<Integer, NumberAndLengthCounter> lapCounterMap = new HashMap<Integer, NumberAndLengthCounter>();
    private final SortedSet<Integer> tagSet = new TreeSet<Integer>();
    private final Set<MessagingAddress> nodeSet = new HashSet<MessagingAddress>();
    private int maxNumNode = 0;

    public MessageCounter(String transport, boolean noUPnP) {
        this.config = StatFactory.getDefaultConfiguration();
        if (transport != null) {
            this.config.setMessagingTransport(transport);
        }
        this.config.setDoUPnPNATTraversal(!noUPnP);
    }

    public void start() throws Exception {
        if (this.statCollector == null) {
            this.statCollector = StatFactory.getMessagingCollector(this.config);
            this.statCollector.start(this);
        }
    }

    public void stop() {
        if (this.statCollector != null) {
            this.statCollector.stop();
            this.statCollector = null;
        }
    }

    public synchronized void clear() {
        this.lapCounterMap.clear();
        this.totalCounterMap.clear();
        this.tagSet.clear();
    }

    @Override
    public synchronized void messageSent(MessagingAddress source, MessagingAddress target, int tag, int len) {
        NumberAndLengthCounter c = null;
        c = this.lapCounterMap.get(tag);
        if (c == null) {
            c = new NumberAndLengthCounter();
            this.lapCounterMap.put(tag, c);
            this.tagSet.add(tag);
        }
        c.addLength(len);
        c = this.totalCounterMap.get(tag);
        if (c == null) {
            c = new NumberAndLengthCounter();
            this.totalCounterMap.put(tag, c);
            this.tagSet.add(tag);
        }
        c.addLength(len);
        this.nodeSet.add(source);
        int size = this.nodeSet.size();
        if (size > this.maxNumNode) {
            this.maxNumNode = size;
        }
    }

    @Override
    public void nodeFailed(MessagingAddress node) {
        this.nodeSet.remove(node);
    }

    public synchronized String getCountsString() {
        int length;
        int number;
        NumberAndLengthCounter c;
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("Message count & length in byte (lap):\n");
        int sumLength = 0;
        int sumNumber = 0;
        for (Integer i : this.tagSet) {
            c = this.lapCounterMap.get(i);
            if (c == null) continue;
            number = c.getNumber();
            length = c.getLength();
            sumNumber += number;
            sumLength += length;
            sb.append(Tag.getNameByNumber(i));
            sb.append(", ");
            sb.append(number);
            sb.append(", ");
            sb.append(length);
            sb.append("\n");
        }
        sb.append("message count, length and # of nodes (lap), ");
        sb.append(sumNumber);
        sb.append(", ");
        sb.append(sumLength);
        sb.append(", ");
        sb.append(this.nodeSet.size());
        sb.append("\n\n");
        this.lapCounterMap.clear();
        sb.append("Message count & length in byte (total):\n");
        sumLength = 0;
        sumNumber = 0;
        for (Integer i : this.tagSet) {
            c = this.totalCounterMap.get(i);
            number = c.getNumber();
            length = c.getLength();
            sumNumber += number;
            sumLength += length;
            sb.append(Tag.getNameByNumber(i));
            sb.append(", ");
            sb.append(number);
            sb.append(", ");
            sb.append(length);
            sb.append("\n");
        }
        sb.append("message count, length and # of nodes (total), ");
        sb.append(sumNumber);
        sb.append(", ");
        sb.append(sumLength);
        sb.append(", ");
        sb.append(this.maxNumNode);
        sb.append("\n\n");
        return sb.toString();
    }
}

