/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.scenariogen;

import java.io.PrintWriter;
import ow.tool.scenariogen.NodeStatus;

public class ScenarioGeneratorContext {
    private PrintWriter out;
    int numNodes = 0;
    int numJoiningNodes = 0;
    NodeStatus[] nodeStats = null;

    ScenarioGeneratorContext(int numNodes) {
        this.nodeStats = new NodeStatus[numNodes];
        int i = 0;
        while (i < numNodes) {
            this.nodeStats[i] = new NodeStatus();
            ++i;
        }
        this.numNodes = numNodes;
        this.setJoinStatus(0, true);
    }

    public PrintWriter getWriter() {
        return this.out;
    }

    public PrintWriter setWriter(PrintWriter out) {
        PrintWriter old = this.out;
        this.out = out;
        return old;
    }

    public int getNumberOfNodes() {
        return this.numNodes;
    }

    public void setNumberOfNodes(int num) {
        NodeStatus[] oldStats = this.nodeStats;
        if (num > this.numNodes) {
            this.nodeStats = new NodeStatus[num];
            System.arraycopy(oldStats, 0, this.nodeStats, 0, this.numNodes);
            int i = this.numNodes;
            while (i < num) {
                this.nodeStats[i] = new NodeStatus();
                ++i;
            }
            this.numNodes = num;
        }
    }

    public int getNumberOfJoiningNodes() {
        return this.numJoiningNodes;
    }

    public void setJoinStatusToAllNodes(boolean joined) {
        int i = 0;
        while (i < this.numNodes) {
            this.setJoinStatus(i, true);
            ++i;
        }
        this.numJoiningNodes = this.numNodes;
    }

    public boolean getJoinStatus(int i) {
        NodeStatus stat = this.nodeStats[i];
        return stat.getJoinStatus();
    }

    public boolean setJoinStatus(int i, boolean joined) {
        NodeStatus stat = this.nodeStats[i];
        boolean old = stat.getJoinStatus();
        if (joined != old) {
            this.numJoiningNodes = joined ? ++this.numJoiningNodes : --this.numJoiningNodes;
        }
        return stat.setJoinStatus(joined);
    }
}

