/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.scenariogen.commands;

import java.io.PrintStream;
import java.math.BigInteger;
import java.net.UnknownHostException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchProviderException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingFactory;
import ow.messaging.MessagingProvider;
import ow.messaging.emulator.EmuHostID;
import ow.routing.RoutingAlgorithm;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingAlgorithmFactory;
import ow.routing.RoutingAlgorithmProvider;
import ow.tool.scenariogen.commands.Entry;
import ow.tool.scenariogen.commands.RoutingRuntimeSkeleton;

public class IDClusteringAlgorithm {
    public static void copy(PrintStream out, Set<Set<Entry>> resultSet, Set<Entry> kvPairSet, int clusterSize) {
        while (!kvPairSet.isEmpty()) {
            LinkedHashSet<Entry> s = new LinkedHashSet<Entry>();
            resultSet.add(s);
            int i = 0;
            for (Entry e : kvPairSet) {
                if (i++ >= clusterSize) break;
                s.add(e);
            }
            kvPairSet.removeAll(s);
        }
    }

    public static void cluster(PrintStream out, Set<Set<Entry>> resultSet, Set<Entry> kvPairSet, int clusterSize, RoutingAlgorithm algo) {
        int idSizeInByte = algo.getConfiguration().getIDSizeInByte();
        ID supposedNode = ID.getID(new byte[idSizeInByte], idSizeInByte);
        int count = 0;
        while (!kvPairSet.isEmpty()) {
            LinkedHashSet<Entry> s = new LinkedHashSet<Entry>();
            resultSet.add(s);
            Entry best = null;
            int i = 0;
            while (i < clusterSize) {
                if (kvPairSet.isEmpty()) break;
                BigInteger bestDistance = BigInteger.ONE.shiftLeft(idSizeInByte * 8);
                for (Entry e : kvPairSet) {
                    BigInteger distance;
                    if (!s.isEmpty()) {
                        distance = BigInteger.ZERO;
                        for (Entry tgt : s) {
                            BigInteger d = algo.distance(tgt.getID(), e.getID());
                            distance = distance.add(d);
                        }
                        distance = distance.divide(BigInteger.valueOf(s.size()));
                    } else {
                        distance = algo.distance(supposedNode, e.getID());
                    }
                    if (bestDistance.compareTo(distance) <= 0) continue;
                    best = e;
                    bestDistance = distance;
                }
                kvPairSet.remove(best);
                s.add(best);
                if (++count % 100 == 0) {
                    out.print(" " + count);
                }
                ++i;
            }
            supposedNode = best.getID();
        }
        out.println();
    }

    public static void alignWithNodes(PrintStream out, Set<Set<Entry>> resultSet, Set<Entry> kvPairSet, int clusterSize, RoutingAlgorithm algo, int numNodes) {
        int idSizeInByte = algo.getConfiguration().getIDSizeInByte();
        MessagingProvider msgProvider = null;
        try {
            msgProvider = MessagingFactory.getProvider("Emulator", null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
        LinkedHashSet<ID> nodeIDSet = new LinkedHashSet<ID>();
        EmuHostID.setInitialID(0);
        EmuHostID hostID = EmuHostID.getNewInstance();
        int i = 0;
        while (i < numNodes) {
            hostID = EmuHostID.getNewInstance();
            MessagingAddress addr = null;
            try {
                addr = msgProvider.getMessagingAddress(hostID.toString(), 3997);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            IDAddressPair p = IDAddressPair.getIDAddressPair(idSizeInByte, addr);
            nodeIDSet.add(p.getID());
            ++i;
        }
        LinkedHashMap<ID, LinkedHashSet<Entry>> table = new LinkedHashMap<ID, LinkedHashSet<Entry>>();
        int count = 0;
        for (Entry e : kvPairSet) {
            BigInteger bestDistance = BigInteger.ONE.shiftLeft(idSizeInByte * 8);
            ID best = null;
            for (ID nodeID : nodeIDSet) {
                BigInteger distance = algo.distance(nodeID, e.getID());
                if (distance.compareTo(bestDistance) >= 0) continue;
                bestDistance = distance;
                best = nodeID;
            }
            LinkedHashSet<Entry> s = (LinkedHashSet<Entry>)table.get(best);
            if (s == null) {
                s = new LinkedHashSet<Entry>();
                table.put(best, s);
            }
            s.add(e);
            out.print(".");
            if (++count % 100 != 0) continue;
            out.print(count);
        }
        block7: for (ID nodeID : nodeIDSet) {
            LinkedHashSet<Entry> s = (LinkedHashSet<Entry>)table.remove(nodeID);
            if (s == null) continue;
            while (true) {
                int size;
                if ((size = s.size()) < clusterSize) {
                    Set anotherSet;
                    BigInteger bestDistance = BigInteger.ONE.shiftLeft(idSizeInByte * 8);
                    ID best = null;
                    for (ID id : table.keySet()) {
                        BigInteger distance;
                        if (id.equals(nodeID) || table.get(id) == null || (distance = algo.distance(nodeID, id)).compareTo(bestDistance) >= 0) continue;
                        bestDistance = distance;
                        best = id;
                    }
                    if (best != null && size + (anotherSet = (Set)table.get(best)).size() <= clusterSize) {
                        table.remove(best);
                        s.addAll(anotherSet);
                        continue;
                    }
                    resultSet.add((Set<Entry>)s);
                    continue block7;
                }
                if (size == clusterSize) {
                    resultSet.add((Set<Entry>)s);
                    continue block7;
                }
                if (size <= clusterSize) continue block7;
                int i2 = clusterSize;
                LinkedHashSet<Entry> newSet = new LinkedHashSet<Entry>();
                for (Entry e : s) {
                    if (i2-- <= 0) {
                        i2 = clusterSize;
                        resultSet.add(newSet);
                        newSet = new LinkedHashSet();
                    }
                    newSet.add(e);
                }
                s = newSet;
            }
        }
        out.println();
    }

    public static RoutingAlgorithm getRoutingAlgorithm(PrintStream out, String algoName, int idSizeInByte) {
        RoutingAlgorithm algo;
        RoutingAlgorithmProvider algoProvider;
        try {
            algoProvider = RoutingAlgorithmFactory.getProvider(algoName);
        }
        catch (NoSuchProviderException e) {
            out.println("No such routing algorithm: " + algoName);
            return null;
        }
        RoutingAlgorithmConfiguration algoConf = algoProvider.getDefaultConfiguration();
        if (algoConf.getIDSizeInByte() != idSizeInByte) {
            out.println("Warning: specified ID size is different from the default value (" + algoConf.getIDSizeInByte() + "): " + idSizeInByte);
            algoConf.setIDSizeInByte(idSizeInByte);
        }
        try {
            algo = algoProvider.initializeAlgorithmInstance(algoConf, new RoutingRuntimeSkeleton(algoConf));
        }
        catch (InvalidAlgorithmParameterException e) {
            out.println("An Exception thrown.");
            return null;
        }
        return algo;
    }
}

