/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.util.shellframework;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.MessagingAddress;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingException;
import ow.routing.RoutingHop;
import ow.routing.RoutingResult;
import ow.routing.RoutingService;
import ow.routing.impl.IterativeRoutingDriver;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.Shell;
import ow.tool.util.shellframework.ShellContext;
import ow.tool.util.shellframework.ShellServer;
import ow.util.HighLevelService;
import ow.util.HighLevelServiceConfiguration;

public final class CommandUtil {
    public static <T extends HighLevelService> boolean executeHelp(ShellContext<T> context) {
        PrintStream out = context.getOutputStream();
        List<Command<T>> commandList = context.getCommandList();
        for (Command<T> command : commandList) {
            out.print(String.valueOf(command.getHelp()) + "\r\n");
        }
        out.flush();
        return false;
    }

    public static boolean executeInit(ShellContext<? extends HighLevelService> context, Command<?> cmd) throws UnknownHostException {
        HighLevelService svc = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        HighLevelServiceConfiguration config = svc.getConfiguration();
        int port = config.getSelfPort();
        if (args.length < 1) {
            out.print("usage: " + cmd.getHelp() + "\r\n");
            out.flush();
            return false;
        }
        if (args.length >= 2) {
            port = Integer.parseInt(args[1]);
        }
        MessagingAddress contactAddr = null;
        try {
            contactAddr = svc.joinOverlay(args[0], port);
        }
        catch (UnknownHostException e) {
            out.print("Hostname resolution failed on " + svc.getSelfIDAddressPair().getAddress() + "\r\n");
            out.flush();
            throw e;
        }
        catch (RoutingException e) {
            out.print("routing failed on " + svc.getSelfIDAddressPair() + "\r\n");
        }
        if (contactAddr != null) {
            out.print("contact: " + contactAddr.getHostAddress() + ":" + contactAddr.getPort() + "\r\n");
        } else {
            out.print("joining failed.\r\n");
        }
        out.flush();
        return false;
    }

    public static <T extends HighLevelService> boolean executeSource(ShellContext<T> context, Command<?> cmd) {
        ShellServer<T> shellServer = context.getShellServer();
        HighLevelService dht = (HighLevelService)context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 1) {
            out.print("usage: " + cmd.getHelp() + "\r\n");
            out.flush();
            return false;
        }
        if (shellServer != null) {
            int i = 0;
            while (i < args.length) {
                block5: {
                    FileInputStream in;
                    try {
                        in = new FileInputStream(args[0]);
                    }
                    catch (FileNotFoundException e) {
                        out.print("File not found: " + args[0] + "\r\n");
                        break block5;
                    }
                    Shell<HighLevelService> subShell = new Shell<HighLevelService>(in, out, shellServer, dht, false);
                    subShell.run();
                }
                ++i;
            }
        }
        return false;
    }

    public static StringBuilder buildStatusMessage(HighLevelService svc, int verboseLevel) {
        RoutingService routingSvc = svc.getRoutingService();
        RoutingAlgorithmConfiguration algoConf = svc.getRoutingAlgorithmConfiguration();
        boolean iterative = routingSvc instanceof IterativeRoutingDriver;
        boolean adjustRoot = algoConf.adjustRoot();
        StringBuilder sb = new StringBuilder();
        sb.append("ID and address: ").append(svc.getSelfIDAddressPair().toString(verboseLevel)).append("\r\n");
        sb.append("Routing table:").append("\r\n");
        String routingTableString = svc.getRoutingTableString(verboseLevel).replaceAll("\n", "\r\n");
        sb.append(routingTableString).append("\r\n");
        ID[] keys = svc.getLastKeys();
        RoutingResult[] routingResults = svc.getLastRoutingResults();
        if (keys != null && routingResults != null) {
            sb.append("Last keys & routes: ").append("\r\n");
            sb.append("number of messages: ");
            int numOfMsgs = CommandUtil.calcNumOfMessagesWithoutCollectiveForwarding(routingResults, iterative, adjustRoot);
            sb.append(numOfMsgs);
            sb.append(" -> ");
            numOfMsgs = CommandUtil.calcNumOfMessagesWithCollectiveForwarding(routingResults, iterative, adjustRoot);
            sb.append(numOfMsgs);
            sb.append("\r\n");
            int i = 0;
            while (i < keys.length) {
                if (keys[i] != null && routingResults[i] != null) {
                    sb.append("key[").append(i).append("]: ");
                    sb.append(keys[i].toString(verboseLevel)).append("\r\n");
                    RoutingHop[] route = routingResults[i].getRoute();
                    sb.append("route[").append(i).append("] (length: ").append(route.length - 1).append("): ");
                    sb.append("[");
                    long timeBase = -1L;
                    Serializable[] serializableArray = route;
                    int n = route.length;
                    int n2 = 0;
                    while (n2 < n) {
                        RoutingHop hop = serializableArray[n2];
                        if (timeBase < 0L) {
                            timeBase = hop.getTime();
                        }
                        sb.append("\r\n").append(" ");
                        sb.append(hop.getIDAddressPair().toString(verboseLevel));
                        sb.append(" (").append(hop.getTime() - timeBase).append(")");
                        ++n2;
                    }
                    sb.append("\r\n").append("]").append("\r\n");
                    sb.append("root candidates[").append(i).append("]: ");
                    sb.append("[");
                    serializableArray = routingResults[i].getRootCandidates();
                    n = serializableArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        Serializable r = serializableArray[n2];
                        sb.append("\r\n").append(" ");
                        sb.append(((IDAddressPair)r).toString(verboseLevel));
                        ++n2;
                    }
                    sb.append("\r\n").append("]").append("\r\n");
                }
                ++i;
            }
        }
        return sb;
    }

    private static int calcNumOfMessagesWithoutCollectiveForwarding(RoutingResult[] results, boolean iterative, boolean adjustLastHop) {
        int num = 0;
        int i = 0;
        while (i < results.length) {
            RoutingHop[] route;
            if (results[i] != null && (route = results[i].getRoute()).length > 0) {
                int lastIndex;
                IDAddressPair h;
                IDAddressPair self = route[0].getIDAddressPair();
                int j = 0;
                while (j < route.length - 1) {
                    h = route[j].getIDAddressPair();
                    if (!self.equals(h)) {
                        num += 2;
                    }
                    ++j;
                }
                if (iterative && adjustLastHop) {
                    int preLastIndex = route.length - 2;
                    if (preLastIndex < 0) {
                        preLastIndex = 0;
                    }
                    if (!self.equals(h = route[preLastIndex].getIDAddressPair())) {
                        num += 2;
                    }
                }
                if ((lastIndex = route.length - 1) < 0) {
                    lastIndex = 0;
                }
                if (!self.equals(h = route[lastIndex].getIDAddressPair())) {
                    num = iterative ? (num += 2) : (num += 3);
                }
            }
            ++i;
        }
        return num;
    }

    private static int calcNumOfMessagesWithCollectiveForwarding(RoutingResult[] results, boolean iterative, boolean adjustLastHop) {
        int num = 0;
        IDAddressPair self = null;
        if (iterative && adjustLastHop) {
            HashSet<IDAddressPair> lastHops = new HashSet<IDAddressPair>();
            HashSet<IDAddressPair> preLastHops = new HashSet<IDAddressPair>();
            int i = 0;
            while (i < results.length) {
                if (results[i] != null) {
                    RoutingHop[] route = results[i].getRoute();
                    int len = route.length;
                    preLastHops.add(route[route.length >= 2 ? len - 2 : len - 1].getIDAddressPair());
                    lastHops.add(route[len - 1].getIDAddressPair());
                    if (self == null) {
                        self = route[0].getIDAddressPair();
                    }
                }
                ++i;
            }
            preLastHops.remove(self);
            lastHops.remove(self);
            num += 2 * preLastHops.size();
            num += 2 * lastHops.size();
        }
        ArrayList<List<RoutingHop>> routes = new ArrayList<List<RoutingHop>>();
        int i = 0;
        while (i < results.length) {
            if (results[i] != null && results[i].getRoute().length > 1) {
                ArrayList<RoutingHop> l = new ArrayList<RoutingHop>();
                boolean firstElem = true;
                RoutingHop[] routingHopArray = results[i].getRoute();
                int n = routingHopArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RoutingHop h = routingHopArray[n2];
                    if (firstElem) {
                        if (self == null) {
                            self = h.getIDAddressPair();
                        }
                        firstElem = false;
                    } else {
                        l.add(h);
                    }
                    ++n2;
                }
                if (iterative && adjustLastHop) {
                    l.remove(l.size() - 1);
                }
                if (!l.isEmpty()) {
                    routes.add(l);
                }
            }
            ++i;
        }
        return num += CommandUtil.calcNumOfMessagesWithCollectiveForwarding(routes, iterative, self);
    }

    private static int calcNumOfMessagesWithCollectiveForwarding(List<List<RoutingHop>> routes, boolean iterative, IDAddressPair self) {
        HashSet<IDAddressPair> firstHopSet = new HashSet<IDAddressPair>();
        for (List<RoutingHop> l : routes) {
            RoutingHop h = l.get(0);
            IDAddressPair firstHop = h.getIDAddressPair();
            if (self.equals(firstHop)) continue;
            firstHopSet.add(firstHop);
        }
        int num = 2 * firstHopSet.size();
        ArrayList<List<RoutingHop>> partOfRoutes = new ArrayList<List<RoutingHop>>();
        for (IDAddressPair p : firstHopSet) {
            boolean reachAndCountLastHop = false;
            partOfRoutes.clear();
            Iterator<List<RoutingHop>> itr = routes.iterator();
            while (itr.hasNext()) {
                List<RoutingHop> l = itr.next();
                RoutingHop h = l.get(0);
                IDAddressPair firstHop = h.getIDAddressPair();
                if (!p.equals(firstHop)) continue;
                itr.remove();
                l.remove(0);
                if (l.isEmpty()) {
                    if (self.equals(firstHop)) continue;
                    reachAndCountLastHop = true;
                    continue;
                }
                partOfRoutes.add(l);
            }
            if (!iterative && reachAndCountLastHop) {
                ++num;
            }
            if (partOfRoutes.isEmpty()) continue;
            num += CommandUtil.calcNumOfMessagesWithCollectiveForwarding(partOfRoutes, iterative, self);
        }
        return num;
    }
}

