/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.util.shellframework;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import ow.messaging.util.AccessControlledServerSocket;
import ow.messaging.util.AccessController;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.Interruptible;
import ow.tool.util.shellframework.MessagePrinter;
import ow.tool.util.shellframework.Shell;

public final class ShellServer<T>
implements Runnable {
    public static final String ENCODING = "US-ASCII";
    private final Map<String, Command<T>> commandTable;
    private final List<Command<T>> commandList;
    private final MessagePrinter showPromptPrinter;
    private final MessagePrinter noCommandPrinter;
    private final MessagePrinter emptyLinePrinter;
    private T appDepData;
    private ServerSocket servSock = null;
    protected Thread shellServerThread = null;
    private Set<Interruptible> interruptibleSet = new HashSet<Interruptible>();
    protected Set<PrintStream> outputStreamSet = new HashSet<PrintStream>();
    private Queue<String> messageQueue = new LinkedList<String>();
    private Thread printServer = null;

    public static <C> List<Command<C>> createCommandList(Class<Command<C>>[] commandClasses) {
        ArrayList<Command<C>> commandList = new ArrayList<Command<C>>();
        Class<Command<C>>[] classArray = commandClasses;
        int n = commandClasses.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                Command<C> cmd;
                Class<Command<C>> commandClz = classArray[n2];
                try {
                    cmd = commandClz.newInstance();
                }
                catch (Exception e) {
                    break block3;
                }
                commandList.add(cmd);
            }
            ++n2;
        }
        return commandList;
    }

    public static <C> Map<String, Command<C>> createCommandTable(List<Command<C>> commandList) {
        HashMap<String, Command<C>> commandTable = new HashMap<String, Command<C>>();
        int i = commandList.size() - 1;
        while (i >= 0) {
            String[] names;
            Command<C> cmd = commandList.get(i);
            String[] stringArray = names = cmd.getNames();
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                int j = 1;
                while (j <= name.length()) {
                    String key = name.substring(0, j);
                    commandTable.put(key, cmd);
                    ++j;
                }
                ++n2;
            }
            --i;
        }
        return commandTable;
    }

    public ShellServer(Map<String, Command<T>> commandTable, List<Command<T>> commandList, MessagePrinter showPromptPrinter, MessagePrinter noCommandPrinter, MessagePrinter emptyLinePrinter, T applicationDependentData, int port) {
        this(commandTable, commandList, showPromptPrinter, noCommandPrinter, emptyLinePrinter, applicationDependentData, port, null);
    }

    public ShellServer(Map<String, Command<T>> commandTable, List<Command<T>> commandList, MessagePrinter showPromptPrinter, MessagePrinter noCommandPrinter, MessagePrinter emptyLinePrinter, T applicationDependentData, int port, AccessController ac) {
        this.appDepData = applicationDependentData;
        this.commandTable = commandTable;
        this.commandList = commandList;
        this.showPromptPrinter = showPromptPrinter;
        this.noCommandPrinter = noCommandPrinter;
        this.emptyLinePrinter = emptyLinePrinter;
        if (port >= 0 && port < 65536) {
            try {
                this.servSock = new AccessControlledServerSocket(ac);
                this.servSock.setReuseAddress(true);
                this.servSock.bind(new InetSocketAddress(port));
            }
            catch (IOException e) {
                System.err.println("An Exception thrown:");
                e.printStackTrace();
                return;
            }
            Thread t = new Thread(this);
            t.setName("ShellServer");
            t.setDaemon(true);
            t.start();
            System.out.println("A shell server is waiting on the port tcp/" + port);
        }
    }

    @Override
    public void run() {
        this.shellServerThread = Thread.currentThread();
        while (true) {
            Socket sock;
            try {
                sock = this.servSock.accept();
            }
            catch (IOException e) {
                System.out.println("Halt.");
                break;
            }
            Shell<T> sh = null;
            try {
                sh = new Shell<T>(sock, this, this.commandTable, this.commandList, this.showPromptPrinter, this.noCommandPrinter, this.emptyLinePrinter, this.appDepData);
            }
            catch (Exception e) {
                continue;
            }
            Thread t = new Thread(sh);
            t.setName("A Shell");
            t.setDaemon(false);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInterruptible(Interruptible t) {
        Set<Interruptible> set = this.interruptibleSet;
        synchronized (set) {
            this.interruptibleSet.add(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInterruptible(Interruptible t) {
        Set<Interruptible> set = this.interruptibleSet;
        synchronized (set) {
            this.interruptibleSet.remove(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptAllInterruptible() {
        Set<Interruptible> set = this.interruptibleSet;
        synchronized (set) {
            for (Interruptible t : this.interruptibleSet) {
                t.interrupt();
            }
        }
    }

    public Thread getShellServerThread() {
        return this.shellServerThread;
    }

    public Map<String, Command<T>> getCommandTable() {
        return this.commandTable;
    }

    protected List<Command<T>> getCommandList() {
        return this.commandList;
    }

    protected MessagePrinter getShowPromptPrinter() {
        return this.showPromptPrinter;
    }

    protected MessagePrinter getNoCommandPrinter() {
        return this.noCommandPrinter;
    }

    protected MessagePrinter getEmptyLinePrinter() {
        return this.emptyLinePrinter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(String str) {
        this.startPrintServer();
        Queue<String> queue = this.messageQueue;
        synchronized (queue) {
            this.messageQueue.offer(str);
            this.messageQueue.notify();
        }
    }

    public void println(String str) {
        this.print(String.valueOf(str) + "\n");
    }

    private synchronized void startPrintServer() {
        if (this.printServer == null) {
            PrintServer r = new PrintServer();
            Thread t = new Thread(r);
            t.setName("PrintServer");
            t.setDaemon(true);
            t.start();
            this.printServer = t;
        }
    }

    private class PrintServer
    implements Runnable {
        private PrintServer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                String message = null;
                Queue queue = ShellServer.this.messageQueue;
                synchronized (queue) {
                    try {
                        message = (String)ShellServer.this.messageQueue.remove();
                    }
                    catch (NoSuchElementException e) {
                        message = null;
                    }
                    if (message == null) {
                        try {
                            ShellServer.this.messageQueue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                boolean wroteToStdout = false;
                Set<PrintStream> set = ShellServer.this.outputStreamSet;
                synchronized (set) {
                    for (PrintStream out : ShellServer.this.outputStreamSet) {
                        if (System.out.equals(out)) {
                            wroteToStdout = true;
                        }
                        out.print(message);
                        out.flush();
                    }
                }
                if (wroteToStdout) continue;
                System.out.print(message);
            }
        }
    }
}

