/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.util.vizframework;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JComponent;
import ow.id.ID;
import ow.tool.util.vizframework.ImageManager;

final class MarkPanel
extends JComponent {
    private final ImageManager imageManager;
    private final ID id;
    private final int type;
    private Point location;

    MarkPanel(ImageManager imageManager, ID id, int type) {
        this.imageManager = imageManager;
        this.id = id;
        this.type = type;
        this.resetSize();
        this.setToolTipText(id.toString());
    }

    protected void resetSize() {
        this.setSize(this.imageManager.getMarkWidth(this.type), this.imageManager.getMarkHeight(this.type));
        this.resetLocation();
    }

    protected void resetLocation() {
        this.location = this.imageManager.getMarkLocation(this.id, this.type);
        this.setLocation(this.location);
    }

    @Override
    protected void paintComponent(Graphics g) {
    }

    protected void drawComponent(Graphics g) {
        Image img = this.imageManager.getMarkImage(this.type);
        g.drawImage(img, this.location.x, this.location.y, this);
    }
}

