/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.util.vizframework;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import ow.tool.util.vizframework.GeometryManager;
import ow.tool.util.vizframework.IDSpacePanel;
import ow.tool.util.vizframework.ImageManager;
import ow.tool.util.vizframework.VisualizerUtil;

class VisualizerFrame
extends JFrame {
    private ImageManager imageManager;
    private IDSpacePanel idSpacePanel;
    private GeometryManager[] geometryManagers;
    private int geometryManagerIndex;
    private boolean imageToBeUpdated = true;

    public VisualizerFrame(ImageManager imageManager, int idSizeInBit) {
        this.imageManager = imageManager;
        this.setBackground(Color.WHITE);
        this.initComponents(idSizeInBit);
        this.setTitle("Overlay Visualizer");
        this.setDefaultCloseOperation(3);
        this.pack();
        this.setVisible(true);
    }

    protected synchronized boolean imageToBeUpdated() {
        return this.imageToBeUpdated;
    }

    protected synchronized boolean imageToBeUpdated(boolean flag) {
        boolean old = this.imageToBeUpdated;
        this.imageToBeUpdated = flag;
        return old;
    }

    protected void paintComponent(Graphics g) {
    }

    private void initComponents(int idSizeInBit) {
        QuitAction quitAction = new QuitAction();
        ResetAction resetAction = new ResetAction();
        AboutAction aboutAction = new AboutAction();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(resetAction);
        fileMenu.add(quitAction);
        JMenu scaleMenu = new JMenu("Scale");
        JMenu scaleImageMenu = new JMenu("Scale Image");
        int i = 0;
        while (i < VisualizerUtil.SUPPORTED_SCALES.length) {
            String strScale = VisualizerUtil.SUPPORTED_SCALES[i];
            double scale = 1.0;
            try {
                scale = Double.parseDouble(strScale);
            }
            catch (Exception exception) {
                // empty catch block
            }
            scaleMenu.add(new ScaleAction(this, strScale, scale));
            scaleImageMenu.add(new ScaleImageAction(this, strScale, scale));
            ++i;
        }
        JMenu idSpaceStyleMenu = new JMenu("ID Space Style");
        String packageName = String.valueOf(VisualizerFrame.class.getPackage().getName()) + ".";
        String geomMgrPkg = "geom";
        if (geomMgrPkg.length() > 0) {
            packageName = String.valueOf(packageName) + geomMgrPkg + ".";
        }
        int nGeometryManager = VisualizerUtil.GEOMETRY_MANAGERS.length;
        this.geometryManagers = new GeometryManager[nGeometryManager];
        int i2 = 0;
        while (i2 < nGeometryManager) {
            String cname = String.valueOf(packageName) + VisualizerUtil.GEOMETRY_MANAGERS[i2][0];
            String entryname = VisualizerUtil.GEOMETRY_MANAGERS[i2][1];
            try {
                Class<?> c = Class.forName(cname);
                this.geometryManagers[i2] = (GeometryManager)c.newInstance();
            }
            catch (Exception e) {
                System.err.println("Could not instantiate: " + cname);
                e.printStackTrace();
                System.exit(1);
            }
            idSpaceStyleMenu.add(new IDSpaceStyleAction(entryname, i2, this));
            ++i2;
        }
        this.geometryManagerIndex = 0;
        this.imageManager.setGeometryManager(this.geometryManagers[0]);
        JMenu lfMenu = new JMenu("Look & Feel");
        int i3 = 0;
        while (i3 < VisualizerUtil.LOOK_AND_FEELS.length) {
            block11: {
                String cname = VisualizerUtil.LOOK_AND_FEELS[i3][0];
                String entryname = VisualizerUtil.LOOK_AND_FEELS[i3][1];
                try {
                    Class<?> c = Class.forName(cname);
                }
                catch (ClassNotFoundException e) {
                    break block11;
                }
                lfMenu.add(new LFAction(this, entryname, cname));
            }
            ++i3;
        }
        JMenu helpMenu = new JMenu("Help");
        helpMenu.add(aboutAction);
        JMenuBar menubar = new JMenuBar();
        menubar.add(fileMenu);
        menubar.add(scaleMenu);
        menubar.add(scaleImageMenu);
        menubar.add(idSpaceStyleMenu);
        menubar.add(lfMenu);
        menubar.add(helpMenu);
        this.setJMenuBar(menubar);
        JToolBar toolbar = new JToolBar();
        JButton resetButton = toolbar.add(resetAction);
        JButton quitButton = toolbar.add(quitAction);
        contentPane.add((Component)toolbar, "North");
        resetButton.setFocusable(false);
        quitButton.setFocusable(false);
        this.idSpacePanel = new IDSpacePanel(this, this.imageManager);
        contentPane.add((Component)this.idSpacePanel, "West");
        GeometryManager[] geometryManagerArray = this.geometryManagers;
        int n = this.geometryManagers.length;
        int n2 = 0;
        while (n2 < n) {
            GeometryManager geom = geometryManagerArray[n2];
            geom.setNodeOrderMap(this.idSpacePanel.getNodeOrderMap());
            ++n2;
        }
        VisualizerFocusTraversalPolicy ftPolicy = new VisualizerFocusTraversalPolicy(this.idSpacePanel);
        this.setFocusTraversalPolicy(ftPolicy);
    }

    public IDSpacePanel getIDSpacePanel() {
        return this.idSpacePanel;
    }

    protected void setScale(double scale) {
        this.imageManager.setScale(scale);
        this.idSpacePanel.resetSize();
        this.pack();
        this.repaint();
    }

    protected void setImageScale(double scale) {
        this.imageManager.setImageScale(scale);
        this.idSpacePanel.resetSize();
        this.pack();
        this.repaint();
    }

    protected void setGeometryManager(int index) {
        GeometryManager currentGM = this.geometryManagers[this.geometryManagerIndex];
        GeometryManager nextGM = this.geometryManagers[index];
        currentGM.stopMoment();
        this.imageManager.setGeometryManager(nextGM);
        this.setScale(nextGM.getScale());
    }

    protected void nextGeometryManager() {
        GeometryManager currentGM = this.geometryManagers[this.geometryManagerIndex];
        ++this.geometryManagerIndex;
        if (this.geometryManagerIndex >= this.geometryManagers.length) {
            this.geometryManagerIndex = 0;
        }
        GeometryManager nextGM = this.geometryManagers[this.geometryManagerIndex];
        currentGM.stopMoment();
        this.imageManager.setGeometryManager(nextGM);
        this.setScale(nextGM.getScale());
    }

    protected void previousGeometryManager() {
        GeometryManager currentGM = this.geometryManagers[this.geometryManagerIndex];
        --this.geometryManagerIndex;
        if (this.geometryManagerIndex < 0) {
            this.geometryManagerIndex = this.geometryManagers.length - 1;
        }
        GeometryManager nextGM = this.geometryManagers[this.geometryManagerIndex];
        currentGM.stopMoment();
        this.imageManager.setGeometryManager(nextGM);
        this.setScale(nextGM.getScale());
    }

    protected GeometryManager[] getGeometryManagers() {
        return this.geometryManagers;
    }

    @Override
    public boolean isResizable() {
        return false;
    }

    private class AboutAction
    extends AbstractAction {
        AboutAction() {
            super("About Overlay Visualizer");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VisualizerUtil.showMessage(VisualizerFrame.this, "Overlay Visualizer for Overlay Weaver\nCopyright 2006-2007 Kazuyuki Shudo, National Institute of Advanced Industrial Science and Technology (AIST), and contributors");
        }
    }

    private class IDSpaceStyleAction
    extends AbstractAction {
        int geometryManagerIndex;
        VisualizerFrame vizFrame;

        IDSpaceStyleAction(String entryname, int geometryManagerIndex, VisualizerFrame f) {
            super(entryname);
            this.geometryManagerIndex = geometryManagerIndex;
            this.vizFrame = f;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            this.vizFrame.setGeometryManager(this.geometryManagerIndex);
        }
    }

    private class LFAction
    extends AbstractAction {
        private Window windowToBeUpdated;
        private String classLF;

        LFAction(Window w, String entryname, String classLF) {
            super(entryname);
            this.windowToBeUpdated = w;
            this.classLF = classLF;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            try {
                UIManager.setLookAndFeel(this.classLF);
                SwingUtilities.updateComponentTreeUI(this.windowToBeUpdated);
                this.windowToBeUpdated.pack();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class QuitAction
    extends AbstractAction {
        QuitAction() {
            super("Quit");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VisualizerUtil.quit(VisualizerFrame.this, 0);
        }
    }

    private class ResetAction
    extends AbstractAction {
        ResetAction() {
            super("Reset");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VisualizerFrame.this.imageManager.getGeometryManager().resetIncline();
            VisualizerFrame.this.idSpacePanel.resetLocation();
        }
    }

    public class ScaleAction
    extends AbstractAction {
        private VisualizerFrame vizframe;
        private double scale;

        ScaleAction(VisualizerFrame f, String entryname, double scale) {
            super(entryname);
            this.vizframe = f;
            this.scale = scale;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            this.vizframe.setScale(this.scale);
        }
    }

    public class ScaleImageAction
    extends AbstractAction {
        private VisualizerFrame vizframe;
        private double scale;

        ScaleImageAction(VisualizerFrame f, String entryname, double scale) {
            super(entryname);
            this.vizframe = f;
            this.scale = scale;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            this.vizframe.setImageScale(this.scale);
        }
    }

    private static class VisualizerFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private final Component focused;

        VisualizerFocusTraversalPolicy(Component focused) {
            this.focused = focused;
        }

        @Override
        public Component getInitialComponent(Window w) {
            return this.focused;
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return this.focused;
        }

        @Override
        public Component getFirstComponent(Container root) {
            return this.focused;
        }

        @Override
        public Component getLastComponent(Container root) {
            return this.focused;
        }

        @Override
        public Component getComponentAfter(Container root, Component c) {
            return this.focused;
        }

        @Override
        public Component getComponentBefore(Container root, Component c) {
            return this.focused;
        }
    }
}

