/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.util.vizframework.geom;

import java.awt.Shape;
import java.awt.geom.Point2D;
import java.math.BigInteger;
import java.util.Map;
import ow.id.ID;
import ow.tool.util.vizframework.GeometryManager;
import ow.tool.util.vizframework.IDSpacePanel;

public abstract class AbstractGeometryManager
implements GeometryManager {
    int idSizeInBit;
    double idSpaceSize;
    private int numOfNodes;
    private Map<ID, Integer> nodeOrderMap;
    private double scale;
    private double inclineX = 0.0;
    private double inclineY = 0.0;
    double inclineAngle;
    double inclineScale;
    private double inclineDegree;
    private double momentX;
    private double momentY;
    private final int origIDSpaceWidth = 500;
    private final int origIDSpaceHeight = 500;
    private int idSpaceWidth;
    private int idSpaceHeight;
    private long inclineChangedTime;
    private MomentRunner momentRunner;

    protected AbstractGeometryManager(int idSizeInBit) {
        this.setIDSizeInBit(idSizeInBit);
        this.setScale(1.0);
    }

    @Override
    public synchronized int getIDSizeInBit() {
        return this.idSizeInBit;
    }

    @Override
    public synchronized void setIDSizeInBit(int idSizeInBit) {
        this.idSizeInBit = idSizeInBit;
        this.idSpaceSize = BigInteger.ONE.shiftLeft(this.idSizeInBit).doubleValue();
    }

    @Override
    public synchronized int getNumOfNodes() {
        return this.numOfNodes;
    }

    @Override
    public synchronized void setNumOfNodes(int num) {
        this.numOfNodes = num;
    }

    @Override
    public synchronized Map<ID, Integer> getNodeOrderMap() {
        return this.nodeOrderMap;
    }

    @Override
    public synchronized void setNodeOrderMap(Map<ID, Integer> map) {
        this.nodeOrderMap = map;
    }

    @Override
    public synchronized void setScale(double scale) {
        if (scale <= 0.0 || scale == this.scale) {
            return;
        }
        this.scale = scale;
        this.inclineX *= scale;
        this.inclineY *= scale;
        this.idSpaceWidth = (int)(500.0 * scale);
        this.idSpaceHeight = (int)(500.0 * scale);
        this.atanInclineXY();
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @Override
    public void addIncline(double x, double y) {
        this.inclineX += x;
        this.inclineY += y;
        this.momentX = x;
        this.momentY = y;
        this.atanInclineXY();
        this.inclineChangedTime = System.currentTimeMillis();
    }

    @Override
    public void resetIncline() {
        this.inclineX = 0.0;
        this.inclineY = 0.0;
        this.atanInclineXY();
        this.stopMoment();
    }

    @Override
    public void normalizeIncline() {
        double radius = (double)this.idSpaceWidth * (this.inclineDegree / Math.PI);
        this.inclineX = radius * Math.sin(this.inclineAngle);
        this.inclineY = radius * -Math.cos(this.inclineAngle);
    }

    @Override
    public void startMoment(IDSpacePanel panel) {
        long curTime = System.currentTimeMillis();
        if (curTime - this.inclineChangedTime > 100L) {
            return;
        }
        if ((int)this.momentX == 0 && (int)this.momentY == 0) {
            this.momentX = 0.0;
            this.momentY = 0.0;
            return;
        }
        this.momentRunner = new MomentRunner(panel, 100L);
        Thread t = new Thread(this.momentRunner);
        t.setName("MomentRunner in Overlay Visualizer");
        t.setDaemon(true);
        t.start();
    }

    @Override
    public void stopMoment() {
        this.momentX = 0.0;
        this.momentY = 0.0;
        if (this.momentRunner != null) {
            this.momentRunner.stop();
            this.momentRunner = null;
        }
    }

    private void atanInclineXY() {
        this.inclineAngle = Math.atan2(this.inclineY, this.inclineX) + 1.5707963267948966;
        double inclineAbs = Math.sqrt(this.inclineX * this.inclineX + this.inclineY * this.inclineY);
        this.inclineDegree = Math.PI * (inclineAbs / (double)this.idSpaceWidth);
        this.inclineScale = Math.cos(this.inclineDegree);
    }

    @Override
    public abstract Shape getShapeForMessage(ID var1, ID var2);

    @Override
    public abstract Shape getShapeForConnection(ID var1, ID var2);

    @Override
    public abstract Point2D getNodePoint2D(ID var1);

    double getAngle(double id) {
        double ratio = id / this.idSpaceSize;
        double angle = Math.PI * 2 * ratio;
        return angle;
    }

    double getCenterX() {
        return (double)this.idSpaceWidth / 2.0;
    }

    double getCenterY() {
        return (double)this.idSpaceHeight / 2.0;
    }

    @Override
    public int getIDSpaceWidth() {
        return this.idSpaceWidth;
    }

    @Override
    public int getIDSpaceHeight() {
        return this.idSpaceHeight;
    }

    protected Point2D getRotatedPointByRectangular(double x, double y) {
        double angle = Math.atan2(x, -y);
        double radius = Math.sqrt(x * x + y * y);
        return this.getRotatedPointByPolar(angle, radius);
    }

    protected Point2D getRotatedPointByPolar(double angle, double radius) {
        double biasedAngle = angle - this.inclineAngle;
        double biasedX = radius * Math.sin(biasedAngle);
        double biasedY = radius * -Math.cos(biasedAngle) * this.inclineScale;
        double biasedAbs = Math.sqrt(biasedX * biasedX + biasedY * biasedY);
        biasedAngle = Math.atan2(biasedY, biasedX) + 1.5707963267948966 + this.inclineAngle;
        double x = biasedAbs * Math.sin(biasedAngle);
        double y = biasedAbs * -Math.cos(biasedAngle);
        return new Point2D.Double(x += this.getCenterX(), y += this.getCenterY());
    }

    private class MomentRunner
    implements Runnable {
        IDSpacePanel panel;
        long interval;
        private boolean stopped = false;

        MomentRunner(IDSpacePanel panel, long interval) {
            this.panel = panel;
            this.interval = interval;
        }

        void stop() {
            this.stopped = true;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException e) {
                    this.stopped = true;
                }
                if (this.stopped) break;
                AbstractGeometryManager.this.addIncline(AbstractGeometryManager.this.momentX, AbstractGeometryManager.this.momentY);
                this.panel.resetLocation();
            }
        }
    }
}

