/*
 * Decompiled with CFR 0.152.
 */
package ow.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ExpiringSet<T> {
    public static Log logger = LogFactory.getLog(ExpiringSet.class);
    private final Set<T> internalSet = Collections.synchronizedSet(new HashSet());
    private final long expiration;

    public ExpiringSet(long expiration) {
        this.expiration = expiration;
    }

    public void add(final T elem) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ExpiringSet.this.internalSet.add(elem);
                try {
                    try {
                        Thread.sleep(ExpiringSet.this.expiration);
                    }
                    catch (InterruptedException e) {
                        logger.info("Thread#sleep interrupted", e);
                        ExpiringSet.this.internalSet.remove(elem);
                    }
                }
                finally {
                    ExpiringSet.this.internalSet.remove(elem);
                }
            }
        };
        Thread t = new Thread(r);
        t.setName("Expirer on " + elem);
        t.setDaemon(true);
        t.start();
    }

    public boolean contains(T elem) {
        return this.internalSet.contains(elem);
    }

    public void clear() {
        this.internalSet.clear();
    }
}

