/*
 * Decompiled with CFR 0.152.
 */
package ow.util.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ConcurrentNonBlockingThreadPoolExecutor
extends ThreadPoolExecutor {
    private final BlockingQueue<Runnable> taskQueue = new LinkedBlockingQueue<Runnable>();
    private final Object submissionLock = new Object();
    private Thread submittingThread = null;
    private boolean stopped = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentNonBlockingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new SynchronousQueue<Runnable>(), threadFactory);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    Runnable task = null;
                    if (ConcurrentNonBlockingThreadPoolExecutor.this.stopped) break;
                    Object object = ConcurrentNonBlockingThreadPoolExecutor.this.taskQueue;
                    synchronized (object) {
                        while ((task = (Runnable)ConcurrentNonBlockingThreadPoolExecutor.this.taskQueue.poll()) == null) {
                            try {
                                ConcurrentNonBlockingThreadPoolExecutor.this.taskQueue.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    object = ConcurrentNonBlockingThreadPoolExecutor.this.submissionLock;
                    synchronized (object) {
                        while (true) {
                            try {
                                ConcurrentNonBlockingThreadPoolExecutor.super.execute(task);
                            }
                            catch (RejectedExecutionException rejectedExecutionException) {
                                try {
                                    ConcurrentNonBlockingThreadPoolExecutor.this.submissionLock.wait();
                                }
                                catch (InterruptedException interruptedException) {}
                                continue;
                            }
                            break;
                        }
                    }
                }
            }
        };
        ConcurrentNonBlockingThreadPoolExecutor concurrentNonBlockingThreadPoolExecutor = this;
        synchronized (concurrentNonBlockingThreadPoolExecutor) {
            Thread t = new Thread(r);
            t.setName("Task submitting thread in ThreadsFirstThreadPoolExecutor");
            t.setDaemon(true);
            t.start();
            this.submittingThread = t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) {
        BlockingQueue<Runnable> blockingQueue = this.taskQueue;
        synchronized (blockingQueue) {
            this.taskQueue.offer(command);
            this.taskQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        Object object = this.submissionLock;
        synchronized (object) {
            this.submissionLock.notify();
        }
    }

    @Override
    protected synchronized void terminated() {
        this.stopped = true;
        if (this.submittingThread != null) {
            this.submittingThread.interrupt();
            this.submittingThread = null;
        }
    }
}

