/*
 * Decompiled with CFR 0.152.
 */
package ow.util.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import ow.util.concurrent.ConcurrentBlockingThreadPoolExecutor;
import ow.util.concurrent.ConcurrentNonBlockingThreadPoolExecutor;

public final class GlobalThreadPoolExecutors {
    public static final int NUM_THREADS_FOR_POOL = 32;
    public static final String POOLED_THREAD_NAME = "A pooled thread";
    public static final long KEEP_ALIVE_TIME = 3L;
    private static final ExecutorService concurrentBlockingNonDaemonEx = new ConcurrentBlockingThreadPoolExecutor(0, 32, 3L, TimeUnit.SECONDS, new NonDaemonThreadFactory());
    private static final ExecutorService concurrentBlockingDaemonEx = new ConcurrentBlockingThreadPoolExecutor(0, 32, 3L, TimeUnit.SECONDS, new DaemonThreadFactory());
    private static final ExecutorService concurrentNonBlockingNonDaemonEx = new ConcurrentNonBlockingThreadPoolExecutor(0, 32, 3L, TimeUnit.SECONDS, new NonDaemonThreadFactory());
    private static final ExecutorService concurrentNonBlockingDaemonEx = new ConcurrentNonBlockingThreadPoolExecutor(0, 32, 3L, TimeUnit.SECONDS, new DaemonThreadFactory());
    private static final ExecutorService serialBlockingNonDaemonEx = new ThreadPoolExecutor(0, 1, 3L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new NonDaemonThreadFactory());
    private static final ExecutorService serialBlockingDaemonEx = new ThreadPoolExecutor(0, 1, 3L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DaemonThreadFactory());
    private static final ExecutorService serialNonBlockingNonDaemonEx = new ThreadPoolExecutor(0, 1, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NonDaemonThreadFactory());
    private static final ExecutorService serialNonBlockingDaemonEx = new ThreadPoolExecutor(0, 1, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory());

    public static ExecutorService getThreadPool(boolean serial, boolean blocking, boolean daemon) {
        if (!serial) {
            if (!blocking) {
                if (!daemon) {
                    return concurrentNonBlockingNonDaemonEx;
                }
                return concurrentNonBlockingDaemonEx;
            }
            if (!daemon) {
                return concurrentBlockingNonDaemonEx;
            }
            return concurrentBlockingDaemonEx;
        }
        if (!blocking) {
            if (!daemon) {
                return serialNonBlockingNonDaemonEx;
            }
            return serialNonBlockingDaemonEx;
        }
        if (!daemon) {
            return serialBlockingNonDaemonEx;
        }
        return serialBlockingDaemonEx;
    }

    private static final class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName(GlobalThreadPoolExecutors.POOLED_THREAD_NAME);
            t.setDaemon(true);
            return t;
        }
    }

    private static final class NonDaemonThreadFactory
    implements ThreadFactory {
        private NonDaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName(GlobalThreadPoolExecutors.POOLED_THREAD_NAME);
            t.setDaemon(false);
            return t;
        }
    }
}

