/* -*- Mode: C; tab-width: 3; indent-tabs-mode: nil; c-basic-offset: 3 -*- */

/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: image_window.h,v 1.19.2.6 2003/06/03 12:35:20 makeinu Exp $
 */

#ifndef __IMAGE_WINDOW_H__
#define __IMAGE_WINDOW_H__

#include "gimageview.h"
#include "image_view.h"

typedef enum {
   ImgWinCreatingFlag                 = 1 << 0,
   ImgWinShowMenuBarFlag              = 1 << 1,
   ImgWinShowToolBarFlag              = 1 << 2,
   ImgWinShowPlayerFlag               = 1 << 3,
   ImgWinShowStatusBarFlag            = 1 << 4,
   ImgWinHideFrameFlag                = 1 << 5,
   ImgWinSeekBarDraggingFlag          = 1 << 6,
   ImgWinMovieFlag                    = 1 << 7,
   ImgWinMaximizeFlag                 = 1 << 8,
   ImgWinFullScreenFlag               = 1 << 9,
   ImgWinSlideShowRepeatFlag          = 1 << 10,
   ImgWinSlideShowPlayingFlag         = 1 << 11,
   ImgWinSlideShowSeekBarDraggingFlag = 1 << 12
} ImgWinFlags;

struct ImageWindow_Tag
{
   GtkWidget       *window;
   GtkWidget       *menubar_handle;
   GtkWidget       *menubar;
   GtkWidget       *toolbar_handle;
   GtkWidget       *toolbar;
   GtkWidget       *player_handle;
   GtkWidget       *player_bar;
   struct    /* buttons in toolbar */
   {
      GtkWidget *fileopen;
      GtkWidget *prefs;
      GtkWidget *prev;
      GtkWidget *next;
      GtkWidget *xscale;
      GtkWidget *yscale;
      GtkWidget *rotate;
   } button;
   struct    /* buttons in player */
   {
      GtkWidget *prev;
      GtkWidget *rw;
      GtkWidget *play;
      GtkWidget *stop;
      GtkWidget *fw;
      GtkWidget *next;
      GtkWidget *seekbar;
   } player;
   GtkWidget       *main_vbox;  /* Image Container */ 

   GtkWidget       *status_bar_container;
   GtkWidget       *status_bar1;
   GtkWidget       *status_bar2;
   GtkWidget       *progressbar;

   /* sub menus */
   GtkWidget       *view_menu;
   GtkWidget       *move_menu;
   GtkWidget       *help_menu;

   /* flags */
   ImgWinFlags      flags;
   ImageViewPlayerVisibleType player_visible;

   /* window geometory */
   gint             win_x;
   gint             win_y;
   gint             win_width;
   gint             win_height;

   /* Image View */
   ImageView       *iv;

   /* fullscreen window */
   GtkWidget       *fullscreen;
   guint            hide_cursor_timer_id;

   /* informatin about slide show */
   SlideShow       *slideshow;
   guint            slideshow_interval;  /* [msec] */
   gint             slideshow_timer_id;
};


GList       *imagewin_get_list                  (void);
ImageWindow *imagewin_get_shared_window         (void);
void         imagewin_player_set_sensitive_all  (ImageWindow *iw,
                                                 gboolean     sensitive);
void         imagewin_change_image              (ImageWindow *iw,
                                                 ImageInfo   *info);

/* currently, treat only menu bar */
void         imagewin_set_sensitive             (ImageWindow *iw,
                                                 gboolean     sensitive);
void         imagewin_store_win_state_to_config (ImageWindow *iw);
ImageWindow *imagewin_initialize                (ImageInfo   *info);
gboolean     imagewin_create_window             (ImageWindow *iw);
ImageWindow *imagewin_open_window               (ImageInfo   *info);
ImageWindow *imagewin_open_shared_window        (ImageInfo   *info);
ImageWindow *imagewin_open_window_auto          (ImageInfo   *info);
void         imagewin_slideshow_play            (ImageWindow *iw);
void         imagewin_slideshow_stop            (ImageWindow *iw);
void         imagewin_slideshow_set_interval    (ImageWindow *iw,
                                                 guint        interval);
void         imagewin_slideshow_set_repeat      (ImageWindow *iw,
                                                 gboolean     repeat);

#endif /* __IMAGE_WINDOE_H__ */
