/* -*- Mode: C; tab-width: 3; indent-tabs-mode: nil; c-basic-offset: 3 -*- */

/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: thumbnail.h,v 1.15.2.3 2003/06/11 06:41:19 makeinu Exp $
 */

#ifndef __THUMBNAIL_H__
#define __THUMBNAIL_H__

#include "gimageview.h"
#include "gimv_image.h"
#include "fileload.h"
#include "thumbnail_support.h"

#define ICON_SIZE 18

struct Thumbnail_Tag
{
   /* public */
   ImageInfo      *info;   /* read only */

   /* friend */
   ThumbView      *thumb_view;
   GHashTable     *mode_data;

   gboolean        selected;
   gboolean        sync;

   /* private */
   GdkPixmap      *thumbnail;
   GdkBitmap      *thumbnail_mask;
   GdkPixmap      *icon;
   GdkBitmap      *icon_mask;
   gchar          *cache_type;
   gint            thumb_width;
   gint            thumb_height;

   guint           ref_count;
};


Thumbnail     *thumbnail_new                  (ImageInfo      *info);
ThumbView     *thumbnail_get_parent_thumbview (Thumbnail      *thumb);
void           thumbnail_set_parent_thumbview (Thumbnail      *thumb,
                                               ThumbView      *tv);
void           thumbnail_finalize             (Thumbnail      *thumb);
Thumbnail     *thumbnail_ref                  (Thumbnail      *thumb);
void           thumbnail_unref                (Thumbnail      *thumb);
gboolean       thumbnail_create               (Thumbnail      *thumb,
                                               gint            thumb_size,
                                               ThumbLoadType   type);
gboolean       thumbnail_is_loading           (Thumbnail      *thumb);
void           thumbnail_load_stop            (Thumbnail      *thumb);
void           thumbnail_get_thumb            (Thumbnail      *thumb,
                                               GdkPixmap     **pixmap,
                                               GdkBitmap     **mask);
GtkWidget     *thumbnail_get_thumb_by_widget  (Thumbnail      *thumb);
void           thumbnail_get_icon             (Thumbnail      *thumb,
                                               GdkPixmap     **pixmap,
                                               GdkBitmap     **mask);
GtkWidget     *thumbnail_get_icon_by_widget   (Thumbnail      *thumb);
gchar         *thumbnail_get_cache_type       (Thumbnail      *thumb);
gboolean       thumbnail_has_thumbnail        (Thumbnail      *thumb);
gchar         *thumbnail_find_thumbcache      (const gchar    *filename,
                                               gchar         **type);

#endif /* __THUMBNAIL_H__ */
