/* -*- Mode: C; tab-width: 3; indent-tabs-mode: nil; c-basic-offset: 3 -*- */

/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: thumbnail_window.h,v 1.24.2.9 2003/06/09 12:46:13 makeinu Exp $
 */

#ifndef __THUMBNAIL_WINDOW_H__
#define __THUMBNAIL_WINDOW_H__

#include "gimageview.h"

#include "gimv_image_view.h"
#include "thumbnail_view.h"

#define MIN_THUMB_SIZE 4
#define MAX_THUMB_SIZE 640

/* current page of notebook */
#define THUMBWIN_CURRENT_PAGE -1


/* program status */
typedef enum {
   THUMB_WIN_STATUS_NORMAL,
   THUMB_WIN_STATUS_LOADING,
   THUMB_WIN_STATUS_LOADING_BG,
   THUMB_WIN_STATUS_CHECKING_DUPLICATE,
   THUMB_WIN_STATUS_NO_SENSITIVE
} ThumbwinStatus;


typedef enum {
   SORT_NAME,
   SORT_ATIME,
   SORT_MTIME,
   SORT_CTIME,
   SORT_SIZE,
   SORT_TYPE,
   SORT_WIDTH,
   SORT_HEIGHT,
   SORT_AREA,
   SORT_NONE
} SortItem;


typedef enum {
   SORT_REVERSE          = 1 << 0,
   SORT_CASE_INSENSITIVE = 1 << 1,
   SORT_DIR_INSENSITIVE  = 1 << 2
} SortFlag;


typedef struct ThumbwinComposeType_Tag {
   gboolean pane1_horizontal;
   gboolean pane2_horizontal;
   gboolean pane2_attach_to_child1;
   gint     widget_type[3];
} ThumbwinComposeType;

extern ThumbwinComposeType compose_type[];


/* thumbnail window composition */
struct ThumbWindow_Tag
{
   GtkWidget *window;
   GtkWidget *main_vbox;

   /* top of window (menu & toolbar) */
   GtkWidget *menubar;
   GtkWidget *menubar_handle;
   GtkWidget *toolbar;
   GtkWidget *toolbar_handle;
   GtkWidget *location_entry;
   GtkWidget *disp_mode_menu;

   /* middle of window (main contents) */
   GtkWidget *main_contents;
   GtkWidget *dirview;
   GtkWidget *notebook;
   GtkWidget *preview;
   GtkWidget *pane1;
   GtkWidget *pane2;

   /* dir view module */
   DirView   *dv;

   /* image view module */
   GimvImageView *iv;

   /* commnet view module */
   CommentView *cv;

   /* bottom of window (status bar) */
   GtkWidget *status_bar_container;
   GtkWidget *status_bar1;
   GtkWidget *status_bar2;
   GtkWidget *status_bar3;
   GtkWidget *progressbar;

   /* popup menu */
   GtkWidget *thumbview_popup;

   /* sub menus */
   GtkWidget *view_menu;
   GtkWidget *sort_menu;
   GtkWidget *comp_menu;

   struct    /* menuitems */
   {
      GtkWidget *file;
      GtkWidget *edit;
      GtkWidget *view;
      GtkWidget *tool;

      GtkWidget *dirview;
      GtkWidget *preview;
      GtkWidget *menubar;
      GtkWidget *toolbar;
      GtkWidget *dir_toolbar;
      GtkWidget *statusbar;
      GtkWidget *tab;
      GtkWidget *preview_tab;
      GtkWidget *fullscr;

      GtkWidget *layout[6];

      GtkWidget *select;
      GtkWidget *unselect;
      GtkWidget *refresh;
      GtkWidget *reload;
      GtkWidget *recreate;

      GtkWidget *rename;
      GtkWidget *copy;
      GtkWidget *move;
      GtkWidget *link;
      GtkWidget *delete;

      GtkWidget *find_sim;

      GtkWidget *sort_name;
      GtkWidget *sort_access;
      GtkWidget *sort_time;
      GtkWidget *sort_change;
      GtkWidget *sort_size;
      GtkWidget *sort_type;
      GtkWidget *sort_width, *sort_height, *sort_area;
      GtkWidget *sort_rev, *sort_case, *sort_dir;
   } menuitem;

   struct    /* buttons in toolbar */
   {
      GtkWidget *fileopen;
      GtkWidget *prefs;
      GtkWidget *refresh;
      GtkWidget *skip;
      GtkWidget *stop;
      GtkWidget *prev;
      GtkWidget *next;
      GtkWidget *quit;
      GtkWidget *size_spin;
   } button;

   /* window status */
   ThumbwinStatus status;
   gboolean   show_dirview;
   gboolean   show_preview;
   gboolean   fullscreen;
   gint       win_x;
   gint       win_y;
   gint       win_width;
   gint       win_height;
   gint       pane_size1;
   gint       pane_size2;
   gchar     *thumb_disp_mode;
   GimvImageViewPlayerVisibleType player_visible;
   SortItem   sortitem;
   SortFlag   sortflags;
   gint       layout_type;
   GtkPositionType tab_pos;
   gboolean   changing_layout;

   gint   filenum; /* image files number in this window */
   gint   pagenum; /* notebook pages number in this window */
   gint   newpage_count;
   gulong filesize;

   /* File open dialog */
   GtkWidget *open_dialog;

#ifdef USE_GTK2
   GSList *accel_group_list;
#endif
};

extern GtkWidget *newest_tab;
extern gchar    **disp_mode_labels;
extern gint collection_page_count;


GList       *thumbwin_get_list                  (void);
ThumbView   *thumbwin_find_thumbtable           (ThumbWindow    *tw,
                                                 gint            pagenum);
void         thumbwin_set_statusbar_page_info   (ThumbWindow    *tw,
                                                 gint            pagenum);
void         thumbwin_loading_update_progress   (ThumbWindow    *tw,
                                                 gint            pagenum);
void         thumbwin_set_sensitive             (ThumbWindow    *tw,
                                                 ThumbwinStatus  status);
void         thumbwin_set_tab_label_text        (GtkWidget      *page_container,
                                                 const gchar    *title);
void         thumbwin_set_tab_label_state       (GtkWidget      *page_container,
                                                 GtkStateType    state);
GtkWidget   *thumbwin_create_new_tab            (ThumbWindow    *tw);
GtkWidget   *thumbwin_detach_tab                (ThumbWindow    *tw_dest,
                                                 ThumbWindow    *tw_src,
                                                 ThumbView      *tv);
void         thumbwin_close_tab                 (ThumbWindow    *tw,
                                                 gint            page);
void         thumbwin_reload_thumbnail          (ThumbWindow    *tw,
                                                 ThumbLoadType   type);
void         thumbwin_open_dirview              (ThumbWindow    *tw);
void         thumbwin_close_dirview             (ThumbWindow    *tw);
void         thumbwin_open_preview              (ThumbWindow    *tw);
void         thumbwin_close_preview             (ThumbWindow    *tw);
void         thumbwin_location_entry_set_text   (ThumbWindow    *tw,
                                                 const gchar    *location);
SortItem     thumbwin_get_sort_type             (ThumbWindow    *tw,
                                                 SortFlag       *flags_ret);
/* currently, only THUMBWIN_CURRENT_PAGE will be accepted */
void         thumbwin_sort_thumbnail            (ThumbWindow    *tw,
                                                 SortItem        item,
                                                 SortFlag        flags,
                                                 gint            page);
void         thumbwin_change_layout             (ThumbWindow    *tw,
                                                 gint            layout);
void         thumbwin_swap_component            (ThumbWindow    *tw,
                                                 gint            com1,
                                                 gint            com2);
ThumbWindow *thumbwin_open_window               (void);
void         thumbwin_store_win_state_to_config (ThumbWindow    *tw);

/* FIXMEEEEEEEEEEEEEEEEEE!! (TOT */
void         thumbwin_notebook_drag_src_unset (ThumbWindow *tw);
void         thumbwin_notebook_drag_src_reset (ThumbWindow *tw);
#ifdef USE_GTK2
void         thumbwin_remove_key_accel        (ThumbWindow *tw);
void         thumbwin_reset_key_accel         (ThumbWindow *tw);
#endif /* USE_GTK2 */
/* END FIXMEEEEEEEEEEEEEEEEEE!! (TOT */

#endif /* __THUMBNAIL_WINDOW_H__ */
