/* -*- Mode: C; tab-width: 3; indent-tabs-mode: nil; c-basic-offset: 3 -*- */

/*
 * GImageView
 * Copyright (C) 2002 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: thumbtable_prefs.c,v 1.2 2003/06/13 09:43:18 makeinu Exp $
 */

#include "thumbtable_prefs.h"

#include "gtk2-compat.h"
#include "gtkutils.h"
#include "intl.h"
#include "gimv_prefs_ui_utils.h"
#include "gimv_prefs_win.h"
#include "gimv_plugin.h"

typedef struct ThumbTableConf_Tag
{
   gint     colnum_min, colnum_max;
   gint     row_space, col_space, button_border_width;
   gboolean centering;
} ThumbTableConf;

ThumbTableConf ttable_conf, *ttable_conf_pre;

static GimvPluginPrefsEntry ttable_prefs_entry [] = {
   {"colnum_min",          GIMV_PLUGIN_PREFS_INT,  "1",    &ttable_conf.colnum_min},
   {"colnum_max",          GIMV_PLUGIN_PREFS_INT,  "10",   &ttable_conf.colnum_max},
   {"row_space",           GIMV_PLUGIN_PREFS_INT,  "8",    &ttable_conf.row_space},
   {"col_space",           GIMV_PLUGIN_PREFS_INT,  "8",    &ttable_conf.col_space},
   {"centering",           GIMV_PLUGIN_PREFS_BOOL, "TRUE", &ttable_conf.centering},
   {"button_border_width", GIMV_PLUGIN_PREFS_INT,  "2",    &ttable_conf.button_border_width},
};

GIMV_PLUGIN_PREFS_GET_VALUE(thumbtable, "Thumbnail View Thumbnail Mode",
                            GIMV_PLUGIN_THUMBVIEW_EMBEDER,
                            ttable_prefs_entry)

static GtkWidget *thumbtable_prefs_ui       (void);
static gboolean   thumbtable_prefs_ui_apply (GimvPrefsWinAction action);

static GimvPrefsWinPage thumbtable_prefs_page =
{
   path:           N_("/Thumbnail Window/Thumbnail View/Thumbnail Table"),
   priority_hint:  30,
   icon:           NULL,
   icon_open:      NULL,
   create_page_fn: thumbtable_prefs_ui,
   apply_fn:       thumbtable_prefs_ui_apply,
};

gboolean
gimv_prefs_ui_thumbtable_get_page (guint idx,
                                   GimvPrefsWinPage **page,
                                   guint *size)
{
   g_return_val_if_fail(page, FALSE);
   *page = NULL;
   g_return_val_if_fail(size, FALSE);
   *size = 0;

   if (idx == 0) {
      *page = &thumbtable_prefs_page;
      *size = sizeof(thumbtable_prefs_page);
      return TRUE;
   } else {
      return FALSE;
   }
}


static void
cb_rotate_min_colnum_value (GtkWidget *widget, GtkWidget *spinner)
{
   gint colmin;

   colmin = GTK_ADJUSTMENT(widget)->value;

   if (colmin > ttable_conf.colnum_max) {
      ttable_conf.colnum_min = ttable_conf.colnum_max; 
      gtk_spin_button_set_value (GTK_SPIN_BUTTON(spinner),
                                 (gfloat) ttable_conf.colnum_min);
   } else {
      ttable_conf.colnum_min = colmin; 
   }
}


static void
cb_rotate_max_colnum_value (GtkWidget *widget, GtkWidget *spinner)
{
   gint colmax;

   colmax = GTK_ADJUSTMENT(widget)->value;

   if (colmax < ttable_conf.colnum_min) {
      ttable_conf.colnum_max = ttable_conf.colnum_min; 
      gtk_spin_button_set_value (GTK_SPIN_BUTTON(spinner),
                                 (gfloat) ttable_conf.colnum_max);
   } else {
      ttable_conf.colnum_max = colmax; 
   }
}


static GtkWidget *
thumbtable_prefs_ui (void)
{
   GtkWidget *main_vbox;
   GtkWidget *frame, *frame_vbox, *table, *vbox, *hbox;
   GtkWidget *label;
   GtkAdjustment *adj;
   GtkWidget *toggle, *spinner;

   GIMV_PLUGIN_PREFS_GET_ALL (thumbtable, ttable_prefs_entry,
                              ttable_conf_pre, ttable_conf);

   main_vbox = gtk_vbox_new (FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(main_vbox), 5);

   /********************************************** 
    * Thumbnail Table Frame
    **********************************************/
   gimv_prefs_ui_create_frame (_("Thumbnail Table"),
                               frame, frame_vbox, main_vbox, FALSE);

   hbox = gtk_hbox_new (FALSE, 5);
   gtk_box_pack_start (GTK_BOX (frame_vbox), hbox, FALSE, FALSE, 0);

   table = gtk_table_new (2, 4, FALSE);
   gtk_table_set_row_spacings (GTK_TABLE (table), 5);
   gtk_table_set_col_spacings (GTK_TABLE (table), 5);
   gtk_container_set_border_width(GTK_CONTAINER(table), 5);
   gtk_box_pack_start (GTK_BOX (hbox), table, FALSE, FALSE, 0);

   /* Minimum column number spinner */
   label = gtk_label_new (_("Minimum Columns"));
   gtk_table_attach (GTK_TABLE (table), label, 0, 1, 0, 1,
                     GTK_EXPAND, GTK_FILL, 0, 0);

   adj = (GtkAdjustment *) gtk_adjustment_new (ttable_conf.colnum_min,
                                               1.0, 256.0, 1.0, 5.0, 0.0);
   spinner = gtkutil_create_spin_button (adj);
   gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
                       GTK_SIGNAL_FUNC (cb_rotate_min_colnum_value), spinner);
   gtk_table_attach (GTK_TABLE (table), spinner, 1, 2, 0, 1,
                     GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 0);

   /* Maximum column number spinner */
   label = gtk_label_new (_("Maximum Columns"));
   gtk_table_attach (GTK_TABLE (table), label, 2, 3, 0, 1,
                     GTK_EXPAND, GTK_FILL, 0, 0);

   adj = (GtkAdjustment *) gtk_adjustment_new (ttable_conf.colnum_max,
                                               1.0, 256.0, 1.0, 5.0, 0.0);
   spinner = gtkutil_create_spin_button (adj);
   gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
                       GTK_SIGNAL_FUNC (cb_rotate_max_colnum_value), spinner);
   gtk_table_attach (GTK_TABLE (table), spinner, 3, 4, 0, 1,
                     GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 0);

   /* Row Spacing spinner */
   label = gtk_label_new (_("Row Spacing"));
   gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2,
                     GTK_EXPAND, GTK_FILL, 0, 0);

   adj = (GtkAdjustment *) gtk_adjustment_new (ttable_conf.row_space,
                                               0.0, 255.0, 1.0, 5.0, 0.0);
   spinner = gtkutil_create_spin_button (adj);
   gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
                       GTK_SIGNAL_FUNC (gtkutil_get_data_from_adjustment_by_int_cb),
                       &ttable_conf.row_space);
   gtk_table_attach (GTK_TABLE (table), spinner, 1, 2, 1, 2,
                     GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 0);

   /* Column Spacing spinner */
   label = gtk_label_new (_("Column Spacing"));
   gtk_table_attach (GTK_TABLE (table), label, 2, 3, 1, 2,
                     GTK_EXPAND, GTK_FILL, 0, 0);

   adj = (GtkAdjustment *) gtk_adjustment_new (ttable_conf.col_space,
                                               0.0, 255.0, 1.0, 5.0, 0.0);
   spinner = gtkutil_create_spin_button (adj);
   gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
                       GTK_SIGNAL_FUNC (gtkutil_get_data_from_adjustment_by_int_cb),
                       &ttable_conf.col_space);
   gtk_table_attach (GTK_TABLE (table), spinner, 3, 4, 1, 2,
                     GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 0);

   /* Move to new tab automatically or not */
   toggle = gtkutil_create_check_button (_("Centering"),
                                         ttable_conf.centering,
                                         gtkutil_get_data_from_toggle_cb,
                                         &ttable_conf.centering);
   gtk_box_pack_start (GTK_BOX (frame_vbox), toggle, FALSE, FALSE, 5);

   /**********************************************
    * Thumbnail Button Frame
    **********************************************/
   gimv_prefs_ui_create_frame (_("Thumbnail Button"),
                               frame, vbox, main_vbox, FALSE);

   hbox = gtk_hbox_new (FALSE, 10);
   gtk_container_set_border_width (GTK_CONTAINER(hbox), 5);
   gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

   /* Minimum border width spinner */
   label = gtk_label_new (_("Minimum Border Width"));
   gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 0);

   adj = (GtkAdjustment *) gtk_adjustment_new (ttable_conf.button_border_width,
                                               0.0, 32.0, 1.0, 5.0, 0.0);
   spinner = gtkutil_create_spin_button (adj);
   gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
                       GTK_SIGNAL_FUNC (gtkutil_get_data_from_adjustment_by_int_cb),
                       &ttable_conf.button_border_width);
   gtk_box_pack_start(GTK_BOX(hbox), spinner, FALSE, TRUE, 0);

   gtk_widget_show_all (main_vbox);

   return main_vbox;
}


static gboolean
thumbtable_prefs_ui_apply (GimvPrefsWinAction action)
{
   GIMV_PLUGIN_PREFS_APPLY_ALL (ttable_prefs_entry,
                                "Thumbnail View Thumbnail Mode",
                                GIMV_PLUGIN_THUMBVIEW_EMBEDER,
                                action,
                                ttable_conf_pre, ttable_conf);

   switch (action) {
   case GIMV_PREFS_WIN_ACTION_OK:
   case GIMV_PREFS_WIN_ACTION_CANCEL:
      GIMV_PLUGIN_PREFS_FREE_ALL(ttable_prefs_entry,
                                 ttable_conf_pre, ttable_conf);
   default:
      break;
   }

   return FALSE;
}

