/* -*- Mode: C; tab-width: 3; indent-tabs-mode: nil; c-basic-offset: 3 -*- */

/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: listview.h,v 1.3 2003/06/18 09:26:54 makeinu Exp $
 */

#ifndef __LISTVIEW_H__
#define __LISTVIEW_H__

#include "gimageview.h"
#include "thumbnail_view.h"

#define LIST_VIEW_LABEL  "List (Icon)"
#define LIST_THUMB_LABEL "List (Thumbnail)"

#define LISTVIEW_DEFAULT_DATA_ORDER "Name,Size,Time"


GList     *list_view_append_thumb_frames     (ThumbView    *tv,
                                              GList        *start,
                                              gchar        *dest_mode);
GtkWidget *listview_add_thumbnail            (GimvThumb    *thumb,
                                              gchar        *dest_mode,
                                              ThumbLoadType type);
void       listview_redraw                   (ThumbView    *tv,
                                              gchar        *dest_mode,
                                              GtkWidget    *scroll_win,
                                              GList       **loadlist);
gboolean   listview_refresh_thumbnail        (GimvThumb    *thumb,
                                              ThumbLoadType type);
GtkWidget *listview_resize                   (ThumbView    *tv);
void       listview_adjust                   (ThumbView    *tv,
                                              GimvThumb    *thumb);
GtkWidget *listview_create                   (ThumbView    *tv,
                                              gchar        *dest_mode);
void       listview_remove_thumbview_data    (ThumbView    *tv);
void       listview_remove_thumbnail_data    (GimvThumb    *thumb);
gboolean   listview_set_selection            (GimvThumb    *thumb,
                                              gboolean      select);
void       listview_set_focus                (ThumbView    *tv,
                                              GimvThumb    *thumb);
GimvThumb *listview_get_focus                (ThumbView    *tv);
gboolean   listview_thumbnail_is_in_viewport (ThumbView    *tv,
                                              GimvThumb    *thumb);

/* for preference */
gint   listview_get_titles_num (void);
gchar *listview_get_title      (gint idx);
gint   listview_get_title_idx  (const gchar *title);
void   listview_apply_config   (void);

#endif /* __LISTVIEW_H__ */
