/* -*- Mode: C; tab-width: 3; indent-tabs-mode: nil; c-basic-offset: 3 -*- */

/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: gimv_thumb.h,v 1.2 2003/07/05 16:41:11 makeinu Exp $
 */

#ifndef __GIMV_THUMB_H__
#define __GIMV_THUMB_H__

#include "gimageview.h"
#include "fileload.h"
#include "gimv_thumb_cache.h"

#define ICON_SIZE 18

struct GimvThumb_Tag
{
   GimvImageInfo  *info;

   /* image */
   GdkPixmap      *thumbnail;
   GdkBitmap      *thumbnail_mask;
   GdkPixmap      *icon;
   GdkBitmap      *icon_mask;
   gchar          *cache_type;

   gint            thumb_width;
   gint            thumb_height;

   guint           ref_count;

   /* will be removed */
   ThumbView      *thumb_view;
   gboolean        selected;
   GHashTable     *mode_data;
};


GimvThumb     *gimv_thumb_new                  (GimvImageInfo  *info);
ThumbView     *gimv_thumb_get_parent_thumbview (GimvThumb      *thumb);
void           gimv_thumb_set_parent_thumbview (GimvThumb      *thumb,
                                                ThumbView      *tv);

void           gimv_thumb_finalize             (GimvThumb      *thumb);
GimvThumb     *gimv_thumb_ref                  (GimvThumb      *thumb);
void           gimv_thumb_unref                (GimvThumb      *thumb);

gboolean       gimv_thumb_load                 (GimvThumb      *thumb,
                                                gint            thumb_size,
                                                ThumbLoadType   type);
gboolean       gimv_thumb_is_loading           (GimvThumb      *thumb);
void           gimv_thumb_load_stop            (GimvThumb      *thumb);

void           gimv_thumb_get_thumb            (GimvThumb      *thumb,
                                                GdkPixmap     **pixmap,
                                                GdkBitmap     **mask);
GtkWidget     *gimv_thumb_get_thumb_by_widget  (GimvThumb      *thumb);
void           gimv_thumb_get_icon             (GimvThumb      *thumb,
                                                GdkPixmap     **pixmap,
                                                GdkBitmap     **mask);
GtkWidget     *gimv_thumb_get_icon_by_widget   (GimvThumb      *thumb);
gchar         *gimv_thumb_get_cache_type       (GimvThumb      *thumb);
gboolean       gimv_thumb_has_thumbnail        (GimvThumb      *thumb);
gchar         *gimv_thumb_find_thumbcache      (const gchar    *filename,
                                                gchar         **type);

#endif /* __GIMV_THUMB_H__ */
