/*
 * Decompiled with CFR 0.152.
 */
package org.ginkgo.gcov.builder;

import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.ginkgo.gcov.parser.IParser;
import org.xml.sax.SAXException;

public abstract class Builder
extends IncrementalProjectBuilder {
    private void cleanDerivedResource(IResource resource) {
        IFile file;
        String name;
        if (resource instanceof IFile && ((name = (file = (IFile)resource).getName()).endsWith(".c") || name.endsWith(".cpp"))) {
            name.replaceFirst("\\.c$", "");
            file.getProject();
        }
    }

    private void deleteMarkers(IFile file) {
        try {
            file.deleteMarkers("org.ginkgo.gcov.lineCoverMarker", true, 0);
            file.deleteMarkers("org.ginkgo.gcov.lineUnCoverMarker", true, 0);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            this.getProject().accept((IResourceVisitor)new SampleResourceVisitor());
        }
        catch (CoreException coreException) {}
    }

    abstract IParser getParser() throws ParserConfigurationException, SAXException;

    abstract void checkXML(IResource var1);

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new SampleDeltaVisitor());
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        super.clean(monitor);
        this.getProject().accept((IResourceVisitor)new SampleResourceCleanVisitor());
    }

    class SampleDeltaVisitor
    implements IResourceDeltaVisitor {
        SampleDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    Builder.this.checkXML(resource);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    Builder.this.cleanDerivedResource(resource);
                    Builder.this.checkXML(resource);
                }
            }
            return true;
        }
    }

    class SampleResourceCleanVisitor
    implements IResourceVisitor {
        SampleResourceCleanVisitor() {
        }

        public boolean visit(IResource resource) {
            if (resource instanceof IFile) {
                String name = resource.getName();
                if (name.endsWith(".c") || name.endsWith(".cpp")) {
                    Builder.this.deleteMarkers((IFile)resource);
                } else if (name.endsWith(".gcda") || name.endsWith(".gcno") || name.endsWith(".gcov")) {
                    try {
                        resource.delete(1, null);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
            return true;
        }
    }

    class SampleResourceVisitor
    implements IResourceVisitor {
        SampleResourceVisitor() {
        }

        public boolean visit(IResource resource) {
            Builder.this.checkXML(resource);
            return true;
        }
    }
}

