#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2008 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: PEC.pm,v 1.2 2002/07/30 17:40:56 gaou Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#

package G::Tools::PEC;

use SubOpt;
use G::Messenger;
use LWP::Simple;

use strict;
use base qw(Exporter);
use SelfLoader;

our @EXPORT = qw(
		 set_essentiality
);


__DATA__

=head1 NAME

G::Tools::PEC - Perl extension for blah blah blah

=head1 SYNOPSIS

  use G::Tools::PEC;
  blah blah blah

=head1 DESCRIPTION

Stub documentation for G::Seq::PEC was created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head1 AUTHOR

A. U. Thor, a.u.thor@a.galaxy.far.far.away

=head1 SEE ALSO

perl(1).

=cut


######################################
#         Main Methods               #
######################################


# set_essentiality ver. 20070219-01
# Author: Kazuharu Arakawa

sub set_essentiality {
    my @args = opt_get(@_);
    my $gb = shift @args;

    if ($gb->{LOCUS}->{id} eq 'U00096' || $gb->{LOCUS}->{id} eq 'NC_000913'){

	my $url = "http://shigen.lab.nig.ac.jp/ecoli/pec/download/files/PECData.dat";
	my $dir = $ENV{HOME} . '/.glang/data/Essentiality.txt';
	mirror($url, $dir);
	die("set_essentiality: cannot retrieve data from PEC.") unless(-e $dir);

	my $i = 1;
	open(FILE, $dir) || die($!);

	while(<FILE>){
	    chomp;
	    my $line = $_;

	    my (@hoge) = split(/\t/);

	    my @list = ($hoge[0], split(/,/, $hoge[1]));

	    my $id;
	    foreach my $gene (@list){
		my $tmp = $gb->gene2id($gene);
		$id = $tmp;
		last if(length $id);
	    }
	    
	    if($hoge[7] == 1){
		$gb->{$id}->{essentiality} = 1;		
	    }elsif($hoge[7] == 2){
		$gb->{$id}->{essentiality} = -1;
	    }
	}
	close(FILE);

   }else{
       msg_error("No essentiality data for this species.\n\n");
   }

    return 1;
}



1;

