# Load the Module::Install bundled in ./inc/
use inc::Module::Install;
    
# Define metadata
name            'g-language';
all_from        'lib/G/IO.pm';
abstract        'G-language Genome Analysis Environment package';
author          'Kazuharu Arakawa <gaou@sfc.keio.ac.jp>';
license         'gpl';
perl_version    '5.008';


# Specific dependencies
requires        'Algorithm::Numerical::Shuffle'  =>   '1.4';
requires        'Bio::Perl'                      =>   '1';
requires        'Chart::Graph::Gnuplot'          =>   '3';
requires        'DBI'                            =>   '1.32';
requires        'DBD::SQLite'                    =>   '1.13';
requires        'File::ShareDir'                 =>   '0.05';
requires        'GD'                             =>   '1';
requires        'GD::Graph::bars'                =>   '1.24';
requires        'GD::Graph::lines'               =>   '1.15';
requires        'HTML::Form'                     =>   '0.0';
requires        'HTTP::Cookies'                  =>   '1.25';
requires        'HTTP::Request::Common'          =>   '1.19';
requires        'IO::Zlib'                       =>   '1.10';
requires        'Image::Size'                    =>   '3';
requires        'LWP::Simple'                    =>   '1.35';
requires        'LWP::UserAgent'                 =>   '2';
requires        'List::Compare'                  =>   '0.3';
requires        'Math::FFT'                      =>   '1.28';
requires        'SOAP::Lite'                     =>   '0.69';
requires        'SVG'                            =>   '2.27';
requires        'Statistics::Descriptive'        =>   '2.6';
requires        'Statistics::LineFit'            =>   '0.06';
requires        'Statistics::RankCorrelation'    =>   '0.1';
requires        'Statistics::TTest'              =>   '1.1';
requires        'Statistics::DependantTTest'     =>   '0.03';
requires        'Statistics::Distributions'      =>   '1.02';
requires        'String::Approx'                 =>   '3.23';
requires        'Sys::Load'                      =>   '0.2';
requires        'Term::ReadLine::Gnu'            =>   '0';
requires        'URI'                            =>   '1.21';
requires        'XML::Namespace'                 =>   '0.02';
requires        'XML::Parser'                    =>   '2.31';
requires        'XML::Simple'                    =>   '2.14';
requires        'Graph::Layout::Aesthetic'       =>   '0.12';

requires_external_bin 'gnuplot';
requires_external_bin 'display';

build_requires   'Test::More'        => '0.42';

#recommends       'Wx'                => '0';

install_script  'bin/G';
install_script  'bin/gimv';
install_script  'bin/glang';
install_script  'bin/seqret.pl';
install_script  'bin/blastall.pl';
install_script  'bin/gserver';
     
install_share   'share';

auto_install;
WriteAll;
