/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include <stdlib.h>
#include <string.h>

#include	<gdk/gdk.h>
#include	<gdk/gdkx.h>

extern "C" {
#include "machine/msequence.h"
}


#include	"v/VDisplay.h"
#include	"machine/v_types2.h"

extern "C" {

#include "task.h"
#include "pri_level.h"
#include "lock_level.h"
#include "v_pango.h"
#include "memory_debug.h"
#include "utils.h"
#include "machine/v_object.h"
#include "v/v_types.h"

void
v_open_disp_external();

void
_mseq_gtk_notif(int (*func)(void*), void * arg, char str[]);
void
_mseq_gtk_notif_end(int (*func)(void*), void * arg, char str[]);


void ms_lock(char * file,int line);
void ms_unlock();
void ms_inheritance(int i_tid,char * file,int line);

int get_tid();
int (*vobject_quit_callback)() = 0;

int running_state = 1;
bool suspend_gtk_main = false;
int gtk_main_thread_id = 0;
extern int loop_task_id;
extern int mseq_flag2;
SEM suspend_gtk_main_lock;

typedef struct notif_t {
	struct notif_t *	next;
	void			(*func)(void*);
	void *			arg;
	char *			ret_ptr;
	char			type;
} NOTIF_T;

int gtk_notif_pipe[2];
NOTIF_T * notif_head,* notif_tail;
int notif_pipe_in;
int notif_waiting = 0;

//SEM notif_lock;
extern void (*ms_lock_func)(char *,int);
extern void (*ms_unlock_func)();
extern void (*ms_inheritance_func)();

extern int ms_lock_cnt;
extern char * ms_lock_file;
extern int ms_lock_line;
extern int ms_lock_tid;

extern SEM mseq_que_lock;
#define notif_lock mseq_que_lock

// ------------------------------
// vobject_init
// ------------------------------


LC_FONT_ENGINE_TYPE * vobj_fet[] = {&pango_font_engine_type,0};


Display *
get_gdk_display(char * dis)
{
Display * ret;
GdkPixmap * pm;

	pm = gdk_pixmap_new(NULL,1,1,1);
	ret = GDK_PIXMAP_XDISPLAY(pm);
	gdk_pixmap_unref(pm);
	return ret;
}


int
vobject_init_m1(int *argc, char ***argv)
{
	suspend_gtk_main_lock = new_lock(LL_VOBJECT);
	
	gtk_init(argc, argv);
	gdk_rgb_init();
	gtk_widget_set_default_colormap(gdk_rgb_get_cmap());
	gtk_widget_set_default_visual(gdk_rgb_get_visual());
	v_open_disp_external();
	v_init_pango();
	return 0;
}

int
vobject_init_m2(int *argc, char ***argv)
{
	return 0;
}


//===================================
// About MS
//===================================

extern MS_INFO * ms_processed;
extern SEM mseq_que_lock;
extern MS_INFO * ms_info_head[PRI_MAX];
extern MS_INFO * ms_info_tail[PRI_MAX];
extern int loop_task_id;
extern int (*exception_function)();
int ms_lock_wait;

int _ms_lock(char * file,int line)
{
int tid;
int i;
	tid = get_tid();
//retry:
	if ( tid != loop_task_id ) {
		for ( i = 0 ; i < PRI_MAX ; i ++ ) {
			if ( ms_info_head[i] ) {
				return -2;
			}
		}
		if ( ms_processed ) {
			return -3;
		}
		if ( ms_lock_tid && ms_lock_tid != tid ) {
			return -4;
		}
		ms_lock_tid = tid;
		ms_lock_cnt ++;
		ms_lock_file = file;
		ms_lock_line = line;
	}
	else {
		if ( ms_lock_tid == 0 ) 
			ms_lock_tid = tid;
		ms_lock_cnt ++;
		ms_lock_file = file;
		ms_lock_line = line;
	}
	return 0;
}

void
ms_lock(char * file,int line)
{
int ret;

retry:
	lock_task(mseq_que_lock);
	_mseq_gtk_notif(0,0,0);
//retry2:
	ms_lock_wait = 1;
	ret = _ms_lock(file,line);
	if ( ret == -3 ) {
		wakeup_task((int)&ms_lock_cnt);
		sleep_task((int)&ms_lock_cnt,mseq_que_lock);
//		lock_task(mseq_que_lock);
		goto retry;
	}
	if ( ret < 0 ) {
		wakeup_task((int)&ms_lock_cnt);
		sleep_task((int)&ms_lock_cnt,mseq_que_lock);
		goto retry;
	}
	ms_lock_wait = 0;
	wakeup_task((int)&ms_lock_wait);
	unlock_task(mseq_que_lock,"ms_lock");
}

void
ms_lock_dont_notif()
{
int ret;

retry:
	lock_task(mseq_que_lock);
	ret = _ms_lock(__FILE__,__LINE__);
	if ( ret == -3 ) {
		wakeup_task((int)&ms_lock_cnt);
		sleep_task((int)&ms_lock_cnt,mseq_que_lock);
		goto retry;
	}
	if ( ret < 0 ) {
		wakeup_task((int)&ms_lock_cnt);
		sleep_task((int)&ms_lock_cnt,mseq_que_lock);
		goto retry;
	}
	unlock_task(mseq_que_lock,"ms_lock");
}

void _ms_unlock()
{
int tid;
	tid = get_tid();
	ms_lock_cnt --;
	if ( ms_lock_cnt == 1 ) {
		wakeup_task((int)&ms_lock_cnt);
	}
	else if ( ms_lock_cnt == 0 ) {
		ms_lock_tid = 0;
		wakeup_task((int)&ms_lock_cnt);
	}
}

void
ms_unlock()
{
	lock_task(mseq_que_lock);
	_ms_unlock();
	unlock_task(mseq_que_lock,"ms_unlock");
}

void
ms_inheritance(int i_tid,char * file,int line)
{
int tid;
	tid = get_tid();
//retry:
	lock_task(mseq_que_lock);
/*
	if ( ms_lock_tid == 0 ) {
		_ms_lock(file,line);
	}
	else if ( ms_lock_tid == i_tid ) {
		for ( ; ms_lock_cnt > 1 ; ) {
			sleep_task((int)&ms_lock_cnt,mseq_que_lock);
			goto retry;
		}
		ms_lock_tid = tid;
		ms_lock_file = file;
		ms_lock_line = line;
	}
	else	er_panic("ms_lock_inheritance");
*/
	ms_lock_tid = tid;
	unlock_task(mseq_que_lock,"ms_unlock");
}


// ------------------------------
// vobject_main
// ------------------------------


int need_notif;

int
call_gtk_main(void *)
{
// called via mseq

//ss_printf("call---\n");
	gtk_main_thread_id = get_tid();
	ms_lock_dont_notif();
	gtk_main();
	ms_unlock();
//ss_printf("call---END\n");
	return 0;
}


void
call_gtk_main_task()
// thread calling gtk_main via msequence
{
	while( mseq_flag2 == 0 )
		sleep(1);
	while ( running_state ) {
		lock_task(mseq_que_lock);
		for ( ; ms_lock_wait ; ) {
			sleep_task((int)&ms_lock_wait,mseq_que_lock);
			lock_task(mseq_que_lock);
		}
		unlock_task(mseq_que_lock,"call_gtk_main_task");
		need_notif = 1;
		ms_do(call_gtk_main,0,0,"call_gtk_main");
		need_notif = 0;
	}
/* test *
	printf(" * test * sleep for 15 sec before quit...\n");
	sleep_sec(15);
	printf("exit...\n");
// end */
	gtk_exit(0);
	exit(0);
}

void
_insert_notif(char type,void (*func)(void*),void * arg,char * ret_ptr)
{
NOTIF_T * t;
	if ( type == 'q' ) {
		if ( notif_tail && notif_tail->type == 'q' )
			return;
	}
	t = (NOTIF_T*)d_alloc(sizeof(*t));
	t->func = func;
	t->arg = arg;
	t->type = type;
	t->ret_ptr = ret_ptr;
	t->next = 0;
	if ( notif_head == 0 ) 
		notif_head = notif_tail = t;
	else {
		notif_tail->next = t;
		notif_tail = t;
	}
	if ( notif_pipe_in == 0 ) {
		write(gtk_notif_pipe[1],"n",1);
		notif_pipe_in = 1;
	}
}

NOTIF_T *
_delete_notif()
{
NOTIF_T * ret;
char ch;
	ret = notif_head;
	if ( ret == 0 ) 
		return 0;
	notif_head = ret->next;
	if ( notif_head == 0 ) {
		notif_tail = 0;
		if ( notif_pipe_in == 0 )
			er_panic("_delete_notif(1)");
		notif_pipe_in = 0;
		if ( read(gtk_notif_pipe[0],&ch,1) < 1 )
			er_panic("_delete_notif(2)");
	}
	return ret;
}

void
exec_in_gtk_main(void(*func)(void*), void *arg)
{
//char ret;
//char *ret_ptr;
	  ms_do((int(*)(void*))func, arg, 1, "from exec_in_gtk_main");
}

void
recv_pipe_notif(gpointer data, gint src, GdkInputCondition cond)
// called from g_main_loop
{
NOTIF_T * t;
	for ( ; ; ) {
		lock_task(notif_lock);
		t = _delete_notif();
		unlock_task(notif_lock,"recv_pipe_notif");
		if ( t == 0 )
			return;
		switch ( t->type ) {
		case 'q':
			gtk_main_quit();
			d_f_ree(t);
			return;
		case 'e':
			(*t->func)(t->arg);

			lock_task(notif_lock);
			*t->ret_ptr = 1;
			wakeup_task((unsigned int)t->arg);
			unlock_task(notif_lock, "recv_pipe_notif");
			d_f_ree(t);
			break;
		default:
			er_panic("recv_pipe_notif(1)");
		}
	}

}

void
_mseq_gtk_notif(int (*func)(void*), void * arg, char str[])
// called in ms_do when request incoming
{
	if ( func != call_gtk_main && need_notif ) {
		_insert_notif('q',0,0,0);
	}
}

void
_mseq_gtk_notif_end(int (*func)(void*), void * arg, char str[])
// called in ms_do when request processed
{
}


int
vobject_main()
{
	extern void (*ms_put_call_back)(int (*func)(void*), void * arg, char str[]);
	extern void (*ms_done_call_back)(int (*func)(void*), void * arg, char str[]);
	
	ms_lock_func = ms_lock;
	ms_unlock_func = ms_unlock;
	ms_inheritance_func = (void(*)())ms_inheritance;
	exception_function = (int(*)())call_gtk_main;

	if ( pipe(gtk_notif_pipe) != 0 )
		er_panic("gtk_notif_pipe");
	gdk_input_add(gtk_notif_pipe[0],GDK_INPUT_READ,recv_pipe_notif,0);
	ms_put_call_back = _mseq_gtk_notif;
	ms_done_call_back = _mseq_gtk_notif_end;
//	notif_lock = new_lock(LL_VOBJECT);
	
	create_task((void(*)(TKEY))call_gtk_main_task,0,PRI_USER_INTERFACE);
	ms_loop();
	return 0;
}


// ------------------------------
// vobject_quit
// ------------------------------

void
_vobject_flush_event()
{
	while (g_main_iteration(FALSE));
}

void
vobject_flush_event()
{
	v_serialized_exec_sub(_vobject_flush_event);
}


int
_vobject_quit()
{
// called via ms
	if ( gtk_main_level() ) {
		while (g_main_iteration(FALSE));
		gtk_main_quit();
	}
	running_state = 0;
	return 1;
}


int
vobject_quit()
{
	if ( vobject_quit_callback && !(*vobject_quit_callback)() )
		return 0;
	VDisplay::get_main_display()->destroy();
	running_state = 0;
	return v_serialized_exec_func(_vobject_quit);
}


// ------------------------------
// vobject_layout
// ------------------------------

void
_vobject_layout()
{
	while (g_main_iteration(FALSE));
}

void
vobject_layout()
{
	v_serialized_exec_sub(_vobject_layout);
}


// ------------------------------
// vobject_beep
// ------------------------------

void
vobject_beep()
{
	gdk_beep();
}


unsigned int
vobject_get_hilite_color()
{
	static unsigned int hilite_color = 0;
	if ( hilite_color )
		return hilite_color;
	GdkColor *c;
	c = &v_serialized_exec_func(gtk_widget_get_default_style)->base[GTK_STATE_SELECTED];
	SET_RGB8_32(hilite_color, c->red>>8, c->green>>8, c->blue>>8, 0xff);
	return hilite_color;
}

// ------------------------------
// changed call_back
// ------------------------------


void
value_changed(GtkWidget *w, gpointer c)
{
	((VObject*)c)->value_changed();
}

void
descriptor_changed(GtkWidget *w, gpointer c)
{
	((VObject*)c)->descriptor_changed();
}


// ------------------------------
// set_styled_descriptor
// ------------------------------

char *
ucd_n_string(const L_CHAR *lc)
{
	char * ret;

	if ( lc == 0 )
		return 0;

	ret = code_convert_lc2str(
		const_cast<L_CHAR*>(lc), &utf8_cm, 0);
	set_buffer(ret);
	return ret;
}


char *
get_machine_string(int *lp,LC_FONT * lf,VFONT * vf,L_CHAR * str)
{
int len;
char * ret;
	ret =  ucd_n_string(str);
	len = strlen(ret);
	if ( lp )
		*lp = len;
	return ret;
}

L_CHAR *
get_lc_from_machine(LC_FONT * lf,VFONT * vf,char * str,int len)
{
char * _str;
L_CHAR * ret;
	_str = (char*)d_alloc(len+1);
	memcpy(_str,str,len);
	_str[len] = 0;
	ret = l_string(&utf8_cm,_str);
	d_f_ree(_str);
	return ret;
}

void
_set_styled_descriptor_style(VInfo * info, char * font, int is_bin)
{
	if ( is_bin )
		info = GTK_BIN(info)->child;
	if ( info ) {
		if ( font ) {
			gtk_widget_modify_font(info,
				pango_font_description_from_string(font));
		}
	}
}

void
_set_styled_descriptor_desc(VInfo * info, char * desc, int is_bin)
{
	if ( is_bin )
		info = GTK_BIN(info)->child;
	if ( info ) {
		if ( desc )
			gtk_label_set_text(GTK_LABEL(info), desc);
		else
			gtk_label_set_text(GTK_LABEL(info), "");
	}
}

void
_set_styled_descriptor(VInfo * info, char * desc, char * font, int is_bin)
{
	_set_styled_descriptor_style(info, font, is_bin);
	_set_styled_descriptor_desc(info, desc, is_bin);
}

char *
_set_styled_descriptor_get_font(
	const L_CHAR * descriptor,
	const LC_WRITING_STYLE * ws,
	int fsize)
{
V_PANGO_FONT * vf;
char *font = 0;
LC_FONT * f;
int	size;
LC_WS_COND cond;
int i;
	
	if ( fsize <= 0 )
		fsize = V_DEFAULT_FSIZE;
	
	if ( ws == 0 ) {
		font = (char*)d_alloc(20);
		sprintf(font,"%i", fsize/10);
		return  font;
	}
	
	cond.cond = WSC_FET_LIST;
	cond.fet = &vobj_fet[0];
	f = lc_select_font(&size,
		const_cast<L_CHAR*>(descriptor),
		l_strlen(const_cast<L_CHAR*>(descriptor)),
		const_cast<LC_WRITING_STYLE*>(ws),
		fsize, &cond,0);
	if ( f ) {
		for ( i = 0 ; i < f->fw_len ; i ++ )
			if ( f->fw_list[i].fe->type ==
			&pango_font_engine_type ) {
			vf = (V_PANGO_FONT*)f->fw_list[i].work;
			font = (char*)d_alloc(
				strlen(vf->fontname) + 20);
			sprintf(font,"%s %i",
				vf->fontname,
				size/10);
			break;
		}
	}
	else	return 0;
	return font;
}

void
set_styled_descriptor(
	const L_CHAR * descriptor,
	const LC_WRITING_STYLE * ws,
	int fsize,
	int vert_desc,
	VInfo * info,
	int is_bin)
{
char *ucd, *font = 0;

	if ( descriptor == 0 ) {
		v_serialized_exec_sub(_set_styled_descriptor, info, (char*)0, font, is_bin);
		return;
	}
	
	font = _set_styled_descriptor_get_font(descriptor, ws, fsize);
	if ( vert_desc )
		ucd = ucd_n_string(v_make_vert_desc(descriptor));
	else
		ucd = ucd_n_string(descriptor);
	
	v_serialized_exec_sub(_set_styled_descriptor, info, ucd, font, is_bin);
	
	if ( font )
		d_f_ree(font);
}


extern "C" char *
v_get_vfont_set_1(
		VFONT ** vfp,
		LC_FONT ** lfp,
		void *info,
		DESCRIPTOR_LIST ** desc_list,
		int no,
		L_CHAR * _desc,
		const LC_WRITING_STYLE *ws,
		int fsize,
		bool vert_desc,
		VSize *min_size)
{
V_PANGO_FONT * vf = 0;
LC_FONT * f = 0;
int	size;
LC_WS_COND cond;
int i;
L_CHAR * descriptor;

	if ( fsize <= 0 )
		fsize = V_DEFAULT_FSIZE;
	
	if ( ws == 0 )
		goto next;
	descriptor  = get_descriptor_char(*desc_list);
	if ( descriptor == 0 || descriptor[0] == 0 ) goto next;
	
	cond.cond = WSC_FET_LIST;
	cond.fet = &vobj_fet[0];
	f = lc_select_font(&size,
		const_cast<L_CHAR*>(descriptor),
		l_strlen(const_cast<L_CHAR*>(descriptor)),
		const_cast<LC_WRITING_STYLE*>(ws),
		fsize, &cond,0);
	if ( f ) {
		for ( i = 0 ; i < f->fw_len ; i ++ )
			if ( f->fw_list[i].fe->type ==
			&pango_font_engine_type ) {
			vf = (V_PANGO_FONT*)f->fw_list[i].work;
/*
			font = (char*)d_alloc(
				strlen(vf->fontname) + 20);
			sprintf(font,"%s %i",
				vf->fontname,
				size/10);
*/
			break;
		}
	}
	d_f_ree(descriptor);

next:
	*vfp = vf;
	*lfp = f;

	if ( _desc == 0 ) {
		return 0;
	}
	
	char * d;
	int len;
	if ( _desc == 0 || _desc[0] == 0 )
		return 0;
	else {
		if ( vert_desc )
			_desc = v_make_vert_desc(_desc);
		d = get_machine_string(&len,f,vf,_desc);
	}
	if ( desc_list && no >= 0 )
		VObject::_set_dl_descriptor(desc_list,no,0,d,len);
	return d;
}


// ------------------------------
// standard set/get status
// ------------------------------

VExError
v_get_status_standard(VObjectStatus *s, int *flags, const VInfo *info)
{
	if ( *flags & VSF_VISIBLE ) {
		s->visible = GTK_WIDGET_VISIBLE(info);
	}
	if ( *flags & VSF_ENABLED ) {
		s->enabled = GTK_WIDGET_SENSITIVE(info);
	}
	if ( *flags & VSF_SIZE ) {
		s->size = (VSize){info->allocation.width, info->allocation.height};
	}
	*flags &= ~(VSF_VISIBLE|VSF_ENABLED|VSF_SIZE);
	return initial_VExError(V_ER_NO_ERR,*flags,0);
}

VExError
v_set_status_standard(const VObjectStatus *s, int flags, VInfo *info)
{
	if ( flags & VSF_ENABLED ) {
		v_serialized_exec_sub(gtk_widget_set_sensitive, info, s->enabled);
	}
	if ( flags & VSF_VISIBLE ) {
		if ( s->visible )
			v_serialized_exec_sub(gtk_widget_show, info);
		else
			v_serialized_exec_sub(gtk_widget_hide, info);
	}
	return initial_VExError(V_ER_NO_ERR,flags&~(VSF_ENABLED|VSF_VISIBLE),0);
}

// ------------------------------
// create_do utility
// ------------------------------

VExError
return_create_do(
	VObject * this_obj,
	VObject * nmp,
	VObjectStatus * this_sts,
	const VObjectStatus * s,
	int flags,
	int already_flags)
{
VExError er,er2;

	if ( flags & VSF_PADDING )
		this_sts->padding = s->padding;
	else 	this_sts->padding = v_default_sts.padding;
	if ( flags & VSF_ALIGN ) {
		this_sts->alignh = s->alignh;
		this_sts->alignv = s->alignv;
	}
	else {
		this_sts->alignh = v_default_sts.alignh;
		this_sts->alignv = v_default_sts.alignv;
	}

	this_obj->set_status(&v_default_sts,VSF_DEF_FLAGS &
			(~(flags|already_flags)));
	er = this_obj->set_status(s,flags & VSF_DEF_FLAGS &
			(~already_flags));
	if ( er.code ) {
		printf("return_create_do error : %s %x %x %x\n",
			this_obj->describe_self(),
			er.code, er.subcode1, er.subcode2);
		return er;
	}
	er.subcode1 = already_flags&(~VSF_ALREADY_FLAGS);
	er2 = nmp->add_child_do(this_obj);
	if ( er2.code ) {
		printf("return_create_do error 2 : %s %x %x %x\n",
			this_obj->describe_self(),
			er2.code, er2.subcode1, er2.subcode2);
		return er2;
	}
	return er;
}

} // extern "C"

