/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"utils.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"mx_format.h"
#include	"ppm_types.h"


XL_SEXP * gb_gmxImportPNM();

void
init_gmxImportPNM(XLISP_ENV * env0,XLISP_ENV * env1)
{
	set_env(env1,l_string(std_cm,"gmxImportPNM"),
		get_func_prim(gb_gmxImportPNM,FO_APPLICATIVE,0,6,6));
}

void
matrix_test(MATRIX * m);

void
matrix_test_1sec(MATRIX * m)
{
static int tim;
int t;
	t = get_xltime();
	if ( t != tim ) 
		matrix_test(m);
	tim = t;
}


XL_SEXP *
gb_gmxImportPNM(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
PPM_INFO ppm;
XL_SEXP * filename;
int step;
int h;
unsigned int * buffer;
unsigned char * col;
unsigned char * ptr;
unsigned int * bp;
unsigned int cc;
int w;
MX_ENTRY * mx_e;
L_CHAR * id;
XL_SEXP * _x,*_y;
XL_SEXP * ch;
INTEGER64 x,y;
MX_CACHE_PARAM p;
INTEGER64 * target;
int level;
XL_SEXP * _level;
int ds_ch;
int i;
unsigned int transparent;
L_CHAR * _transparent;
unsigned char * valid,* vp;

int gn_tree_node,gn_create,gn_wait;

unsigned char aa;

	filename = get_el(s,1);
	if ( get_type(filename) != XLT_STRING )
		goto type_missmatch;
	id = get_sf_attribute(sf,l_string(std_cm,"id"));
	if ( id == 0 )
		goto inv_param;
	_transparent = get_sf_attribute(sf,l_string(std_cm,"transparent"));
	if ( _transparent == 0 )
		transparent = -1;
	else {
		sscanf(n_string(std_cm,_transparent),"%i",&transparent);
		transparent = transparent << 8;
	}
ss_printf("TRANSPARENT = %x\n",transparent);
	ch = get_el(s,2);
	if ( get_type(ch) != XLT_INTEGER )
		goto type_missmatch;
	_level = get_el(s,3);
	if ( get_type(_level) != XLT_INTEGER )
		goto type_missmatch;
	level = _level->integer.data;
	
	_x = get_el(s,4);
	_y = get_el(s,5);
	switch ( get_type(_x) ) {
	case XLT_INTEGER:
		x = _x->integer.data;
		break;
	case XLT_FLOAT:
		x = _x->floating.data;
		break;
	default:
		goto type_missmatch;
	}
	switch ( get_type(_y) ) {
	case XLT_INTEGER:
		y = _y->integer.data;
		break;
	case XLT_FLOAT:
		y = _y->floating.data;
		break;
	default:
		goto type_missmatch;
	}
	mx_e = search_mx_entry_by_id(atoi(n_string(std_cm,id)));
	if ( mx_e == 0 )
		goto inv_param;
	ppm.pi_fd = u_open64(n_string(std_cm,filename->string.data),O_RDONLY);
	if ( ppm.pi_fd < 0 ) {
		goto cannot_open;
	}
	read_header(&ppm);
	if ( strcmp(ppm.pi_type,"P4") == 0 ) {
		fprintf(stderr,"not support the  format P4\n");
		exit(1);
	}
	if ( strcmp(ppm.pi_type,"P5") == 0 )
		step = 1;
	else	step = 3;
	
	col = mxc_alloc(&mx_e->c,step*ppm.pi_width);
	buffer = mxc_alloc(&mx_e->c,sizeof(int)*ppm.pi_width);
	target = mxc_alloc(&mx_e->c,sizeof(INTEGER64)*3);
	target[0] = level;
	target[1] = x;
	target[2] = y;
	
	lseek(ppm.pi_fd,ppm.pi_offset,SEEK_SET);

	flush_mx_cache(&mx_e->c,0);

	gn_tree_node = mx_e->c.gn_tree_node;
	gn_create = mx_e->c.gn_create;
	gn_wait = mx_e->c.gn_wait;
	
	mx_e->c.gn_tree_node = GN_TREE;
	mx_e->c.gn_create = GN_LIST_CREATE;
	mx_e->c.gn_wait = GN_LIST_CREATE;


	set_matrix_env(mx_e->c.m,"create-node","enable");

	p = mx_e->p;
	p.dc = target;
	p.ofs = 0;
	p.data_ptrs[0] = 0;
	p.data_ptrs[1] = 0;
	p.data_ptrs[2] = mxc_alloc(&mx_e->c,sizeof(int*));
	p.data_ptrs[3] = 0;
	p.vector_valid = valid = mxc_alloc(&mx_e->c,ppm.pi_width);

	p.data_ix = mxc_alloc(&mx_e->c,sizeof(MX_CACHE_PARAM_IX)*mx_e->c.m->p.channel_nos);
	for ( i = 0 ; i < mx_e->c.ds_len ; i ++ ) {
		if ( mx_e->c.access_ch[i] == ch->integer.data ) {
			p.data_ix[i].x = 0;
			p.data_ix[i].p = 2;
			ds_ch = i;
		}
		else {
			p.data_ix[i].x = MXC_INVALID;
			p.data_ix[i].p = 0;
		}
	}
	p.vector_len = ppm.pi_width;
	
	((unsigned int**)p.data_ptrs[2])[0] = buffer;

	for ( h = 0 ; h < ppm.pi_height ; h ++ ) {
ss_printf("h = %i/%i   \n",h,ppm.pi_height);
		u_read(ppm.pi_fd,col,ppm.pi_width*step);
		ptr = col;
		bp = buffer;
		vp = valid;
		for ( w = 0 ; w < ppm.pi_width ; w ++ ) {
			switch ( step ) {
			case 1:
				cc = ((unsigned int)(*ptr++));
				*bp++ = (cc<<8) | (cc<<16) | (cc<<24);
				break;
			case 3:
				cc = ((unsigned int)(*ptr++));
				cc = cc << 8;
				cc |= ((unsigned int)(*ptr++));
				cc = cc << 8;
				cc |= ((unsigned int)(*ptr++));
				cc = cc << 8;
//ss_printf("CC %x\n",cc);
				*bp++ = cc;
				break;
			}
			if ( transparent == -1 )
				*vp++ = aa = 1;
			else if ( transparent == cc )
				*vp++ = aa = 0;
			else	*vp++ = aa = 1;
		}
		write_mx_cache_vector(&p);
		target[2] += 1<<(target[0]*mx_e->c.m->dim_divide[0]);
	}

	mx_e->c.gn_tree_node = gn_tree_node;
	mx_e->c.gn_create = gn_create;
	mx_e->c.gn_wait = gn_wait;

	mxc_free(&mx_e->c,col);
	mxc_free(&mx_e->c,buffer);
	mxc_free(&mx_e->c,target);
	mxc_free(&mx_e->c,valid);
	
	mxc_free(&mx_e->c,p.data_ptrs[2]);
	flush_mx_cache(&mx_e->c,0);
	return 0;

type_missmatch:
	flush_mx_cache(&mx_e->c,0);
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"gmxImportPNM"),
		0);
cannot_open:
	flush_mx_cache(&mx_e->c,0);
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_OPEN_FILE,
		l_string(std_cm,"gmxImportPNM"),
		List(n_get_string("cannot open the file"),
			filename,
			-1));
inv_param:
	flush_mx_cache(&mx_e->c,0);
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxImportPNM"),
		List(n_get_string("invalida parameter (attribute id)"),
			-1));
/*
permission_error:
	flush_mx_cache(&mx_e->c,0);
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_PERMISSION_DENIED,
		l_string(std_cm,"gmxImportPNM"),
		n_get_string("file path"));
*/
}

