/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___GPS_H___
#define ___GPS_H___

#include	"stream.h"
#include	"locator.h"

/* ================================ *
              GPS SENTENCE
 * ================================ */

typedef struct GPS_GET_SENTENCE
{
	STREAM *s;
	int cur, start, end;
	char buf[4096];
} GPS_GET_SENTENCE;


GPS_GET_SENTENCE *	gps_get_sentence_start(STREAM *s);
void	gps_get_sentence_end(GPS_GET_SENTENCE *ggs);
const char *	gps_get_sentence(GPS_GET_SENTENCE *ggs);

typedef struct GPGGA {
	int hour, min, ndeg, edeg, quality, sats, adgps, dgps_st;
	float sec, nmin, emin, elev;
	char time_valid, deg_valid, elev_valid, quality_valid, state_valid, dgps_valid;
} GPGGA;

typedef struct GPRMC {
	int year, month, day, hour, min, ndeg, edeg;
	float sec, nmin, emin, speed, direction;
	char state;
	char date_valid, time_valid, deg_valid, speed_valid, dir_valid, state_valid;
} GPRMC;

typedef struct GPGSA {
	char mode;
	int state;
	char state_valid;
} GPGSA;

typedef struct PGRME {
	float hpe, vpe, epe;
	char pe_valid;
} PGRME;

int read_sentence_gga(const char *s, GPGGA *gga);
int read_sentence_rmc(const char *s, GPRMC *rmc);
int read_sentence_gsa(const char *s, GPGSA *gsa);
int read_sentence_pgrme(const char *s, PGRME *pgrme);


/* ================================ *
              LOCATOR_GPS
 * ================================ */

LOCATOR_INFO *init_locator_gps(LOCATOR_INIT *init);
int kill_locator_gps(LOCATOR_INFO *info);

#define LT_GPS_STD	0x1
#define LT_GPS_DGPS	0x2
#define LT_GPS_SIM	0x4

extern LOCATOR_TABLE locator_table_gps;

void
send_location_info_gps(
	LOCATOR_INFO *li,
	GPGGA *gga,
	GPGSA *gsa,
	GPRMC *rmc,
	PGRME *pgrme);
int
gps_check_sentence(const char *sentence);


#endif
