/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef VPFTYPES_H__
#define VPFTYPES_H__

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef BOOL
typedef int BOOL;
#endif

#ifndef MAX_PATH
#define MAX_PATH 512
#endif 

typedef long int LONG;
typedef unsigned char BYTE;
typedef short int SHORT;
typedef float SHORT_FLOAT;
typedef double LONG_FLOAT;

typedef struct TripletId{
	LONG cur_id;
	LONG tile_id;
	LONG ext_id;
}TRIPLET_ID;
TRIPLET_ID* vpf_tripletid_new();
void vpf_tripletid_init(TRIPLET_ID* id);
void vpf_tripletid_delete(TRIPLET_ID* i);

typedef union{
	TRIPLET_ID k;
	LONG i;
}KI;

typedef struct {
	LONG_FLOAT x;
	LONG_FLOAT y;
	LONG_FLOAT z;
}VPF_COORDINATE;
VPF_COORDINATE *vpf_coordinate_new();
void vpf_coordinate_delete(VPF_COORDINATE* c);

typedef struct {
	LONG_FLOAT left;
	LONG_FLOAT top;
	LONG_FLOAT right;
	LONG_FLOAT bottom;
	BOOL is_null;
}VPF_RECT;

typedef struct {
	char year[5];
	char month[3];
	char day[3];
	char hour[3];
	char min[3];
	char sec[3];
	char millisec[5];
	char time_zone;
	char tz_hour_diff[3];
	char tz_min_diff[3];
}VPF_DATE;


typedef enum {
	VPF_NODE,
	VPF_EDGE,
	VPF_FACE,
	VPF_TEXT
}VPF_PRIMITIVE_TYPE;

#endif
