/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"machine/include.h"
#include	"memory_debug.h"
#include	"utils.h"
#include	"version.h"


VERSION * version_list;


void
set_version(VERSION * v)
{
	v->next = version_list;
	version_list = v;
}


VERSION * 
get_version(char * layer)
{
VERSION * ret;
	if ( layer == 0 )
		return version_list;
	ret = version_list;
	for ( ; ret ; ret = ret->next ) {
		if ( strcmp(ret->layer,layer) == 0 )
			return ret;
	}
	return 0;
}

void
free_version_v(VERSION * v)
{
	if ( v->layer )
		d_f_ree(v->layer);
	if ( v->name )
		d_f_ree(v->name);
	if ( v->publisher )
		d_f_ree(v->publisher);
	if ( v->version )
		d_f_ree(v->version);
	if ( v->comment )
		d_f_ree(v->comment);
}

void
free_version(VERSION * v)
{
	free_version_v(v);
	d_f_ree(v);
}

void
copy_version(VERSION * v1,VERSION * v2)
{
	*v1 = *v2;
	if ( v2->layer )
		v1->layer = copy_str(v2->layer);
	if ( v2->name )
		v1->name = copy_str(v2->name);
	if ( v2->publisher )
		v1->publisher = copy_str(v2->publisher);
	if ( v2->version )
		v1->version = copy_str(v2->version);
	if ( v2->comment )
		v1->comment = copy_str(v2->comment);
}





