/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"

char ** SetListbaseEnvv;
int SetListbaseEnvc,v_offset;
XL_SEXP * xl_SetListbaseEnv();


void
init_SetListbaseEnv(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"SetListbaseEnv"),
		get_func_prim(xl_SetListbaseEnv,FO_APPLICATIVE,0,2,3));
}

XL_SEXP *
xl_SetListbaseEnv(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * t,*_target;
XLISP_ENV * target,* ret;
	t = get_el(s,1);
	if ( get_type(t) != XLT_PAIR )
		goto type_missmatch;
	if ( list_length(s) < 3 ) {
		target = 0;
	}
	else {
		_target = get_el(s,2);
		if ( get_type(_target) != XLT_ENV )
			goto type_missmatch;
		target = _target->env.data;
	}
	ret = set_listbase_env(t,target);
	if ( ret == 0 )
		goto invalid_format;
	return get_env(ret);
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"SetListbaseEnv"),
		0);
invalid_format:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_INV_FORMAT,
		l_string(std_cm,"SetListbaseEnv"),
		n_get_string("invalid format of param 1"));
}


