/**********************************************************************
 
	Copyright (C) 2007 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef ___CHIMERA_H___
#define ___CHIMERA_H___

#include	<semaphore.h>
#include	"task.h"

typedef struct _chimera_sem {
	struct _chimera_sem *	next;
	int		level;
	int		tid;
	sem_t		s;
	char *		lock_file;
	int		lock_line;
	HTID		lock_htid;
	char *		unlock_file;
	int		unlock_line;
	HTID		unlock_htid;
	
	char *		create_file;
	int		create_line;
} _CHIMERA_SEM;

typedef _CHIMERA_SEM* CHIMERA_SEM;

int _chimera_create_task(void (*func)(),int data,int pri);
HTID chimera_get_hard_tid(int);
void chimera_lock_task(CHIMERA_SEM,char*,int);
void chimera_unlock_task(CHIMERA_SEM,char*,char*,int);
void chimera_sleep_task(unsigned int,CHIMERA_SEM,int);
void chimera_wakeup_task(unsigned int,int);
void normal_wakeup_task(unsigned int,int);
void chimera_sw_init();
void init_wd();
int normal_wakeup_routine(int,int);
void
chimera_post_event();

#define CHIMERA_N_NONE		0
#define CHIMERA_N_LOCK		1
#define CHIMERA_N_WAKEUP	2
#define CHIMERA_N_WAKEUP_END	3
#define CHIMERA_N_SLEEP		4
#define CHIMERA_N_SLEEP_END	5
#define CHIMERA_N_APP		6

#endif


