/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include "v/VButton.h"
#include "machine/v_object.h"
extern "C" {
#include "memory_debug.h"
}

VExError
VPopupButton::create_do(const VObjectStatus* s, int flags,
		VObject * nmp, void * arg)
{
	list_num = 0;
	list_lc = 0;
	list_ws = 0;
	
	info = v_serialized_exec_func(gtk_option_menu_new);
	v_serialized_exec_sub(g_object_ref, info);
	VIA_MS_G_SIGNAL_CONNECT(info, "changed", ::value_changed, this);

	return return_create_do(this,nmp,&sts,s,flags);
}

void
VPopupButton::destroy_do(VObject * nmp)
{
	return VButton::destroy_do(nmp);
}

VPopupButton::~VPopupButton()
{
}

VExError
VPopupButton::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	
	if ( flags & VSF_VALUE ) {
		s->value = v_serialized_exec_func(gtk_option_menu_get_history, GTK_OPTION_MENU(info));
		flags &= ~VSF_VALUE;
	}
	
	VExError err = merge_VExError_vstatus_type(
		initial_VExError(V_ER_NO_ERR,flags,0),
		VButton::get_status(s,flags));
	V_OP_END
	return err;
};

VExError
VPopupButton::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VExError err = initial_VExError(V_ER_NO_ERR,flags,0);
	
	if ( flags & VSF_VALUE ) {
		v_serialized_exec_sub(gtk_option_menu_set_history,
			GTK_OPTION_MENU(info), (unsigned)s->value);
		err.subcode1 &= ~VSF_VALUE;
	}
	
	err = merge_VExError_vstatus_type(err,VButton::set_status(s,flags));
	
	V_OP_END
	return  err;
}

void
v_popup_button_set_list(GtkOptionMenu *om, VObjectStatus *sts, int n,
			const L_CHAR **list, const LC_WRITING_STYLE **ws)
{
	gtk_option_menu_remove_menu(om);
	GtkWidget *menu = gtk_menu_new();
	GtkWidget *item;
	for ( int i = 0 ; i < n ; i++ ) {
		if ( list[i] ) {
			item = gtk_menu_item_new_with_label("");
			set_styled_descriptor(list[i], ws?ws[i]:sts->ws, sts->fsize, 0, item, 1);
		}
		else
			item = gtk_menu_item_new();
		gtk_widget_show(item);
		gtk_menu_append(menu, item);
	}
	gtk_option_menu_set_menu(om, menu);
	gtk_option_menu_set_history(om, sts->value);
}

VExError
VPopupButton::set_list(int num, const L_CHAR **list, const LC_WRITING_STYLE **ws)
{
	V_OP_START_EX
	VExError err = initial_VExError(V_ER_NO_ERR,0,0);
	
	// copy data into object
	list_num = num;
	list_lc = new L_CHAR*[num];
	if ( ws )
		list_ws = new const LC_WRITING_STYLE*[num];
	for ( int i = 0 ; i < num ; i++ ) {
		list_lc[i] = list[i] ? ll_copy_str(const_cast<L_CHAR*>(list[i])) : 0;
		if ( ws )
			list_ws[i] = ws[i];
	}
	
	// set to the popup button
	v_serialized_exec_sub(v_popup_button_set_list,
		GTK_OPTION_MENU(info), &sts, num, list, ws);
	
	V_OP_END
	return err;
}
VExError
VPopupButton::get_list(int *num, L_CHAR ***list, const LC_WRITING_STYLE ***ws)
{
	V_OP_START_EX
	VExError err = initial_VExError(V_ER_NO_ERR,0,0);
	
	*num = list_num;
	*list = (L_CHAR**)d_alloc(sizeof(L_CHAR*)*list_num);
	set_buffer(*list);
	if ( ws ) {
		if ( list_ws == 0 )
			*ws = 0;
		else {
			*ws = (const LC_WRITING_STYLE**)d_alloc(sizeof(LC_WRITING_STYLE*)*list_num);
			set_buffer(*ws);
		}
	}
	for ( int i = 0 ; i < list_num ; i++ ) {
		if ( list_lc[i] ) {
			(*list)[i] = ll_copy_str(const_cast<L_CHAR*>(list_lc[i]));
			set_buffer((*list)[i]);
		}
		else
			(*list)[i] = 0;
		if ( ws && *ws )
			(*ws)[i] = list_ws[i];
	}
	
	V_OP_END
	return err;
}
