/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<math.h>
#include	"pfc.h"


void
pfc_control(PFC * p,double eval,double d)
{
double dd;
	dd = p->sign*d/sqrt(p->target)*(eval - p->target);
	if ( dd >= 0 )
		p->interval = p->interval + dd;
	else if ( d <= 120*CHECKPOINT_RATE/p->target )
		p->interval = p->interval + dd;
	else	p->interval = p->interval + 
			d*p->target/CHECKPOINT_RATE/120*dd;
	if ( p->interval < INTERVAL_MIN )
		p->interval = INTERVAL_MIN;
}
