/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"gbview.h"
#include	"xlerror.h"



XL_SEXP *
gv_set_visible_resolution(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
RESOURCE * r;
XL_SEXP * reso, * ret;
int er;

	r = get_resource_ptr(&ret,env,s->h.file,s->h.line);
	if ( r == 0 )
		return ret;
	reso = get_el(s,1);
	switch ( get_type(reso) ) {
	case XLT_INTEGER:
		r->h.visible_resolution
			= conv_unit(
				&er,
				get_uenv(gblisp_top_env0),
				reso->integer.data,
				reso->integer.unit,
				l_string(std_cm,"dot/m"));
		break;
	case XLT_FLOAT:
		r->h.visible_resolution
			= conv_unit(
				&er,
				get_uenv(gblisp_top_env0),
				reso->floating.data,
				reso->floating.unit,
				l_string(std_cm,"dot/m"));
		break;
	default:
		goto type_missmatch;
	}
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"set-visible-resolution"),
		List(n_get_string("resolution"),
			n_get_string("type missmatch"),
			-1));
}

