/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<fcntl.h>
#include	<stdlib.h>
#include	"init.h"
#include	"long_char.h"
#include	"memory_routine.h"
#include	"xl.h"
#include	"utils.h"
#include	"acrp.h"
#include	"gbmp.h"
#include	"gb.h"

void
watchdog_exit()
{
	er_panic("GBMP MEMORY");
}

int pid;

int
_main(int argc,char ** argv)
{

pid = getpid();

	init_xl(INI_DONTWAITCHI);
	init_tick_que();
	init_fetch();
	init_mp_work();
	init_lump();

	init_function(gblisp_top_env0,gblisp_top_env1,argc,argv);
	init_mp_Exit(gblisp_top_env1);
	init_server_function(gblisp_top_env0,gblisp_top_env1);
	init_acrp_function(gblisp_top_env0,gblisp_top_env1);
	init_gv_cpu(gblisp_top_env0);

	init_gbs();

	memory_watchdog(watchdog_exit);

	xl_setup_file(argc,argv);


	return 0;
}
