/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___XLoHTTP_H___
#define ___XLoHTTP_H___

#include	"server.h"
#include	"xl.h"

#define METHOD_LEN	10

typedef struct http_err {
	int	code;
	char *	msg;
} HTTP_ERR;


typedef struct HTTP_info {
	short		http_ver;
	short		http_rev;
	int		err;
	HTTP_ERR	err2;
	char *		method;
	char *		dir;
	char *		content_type;
 	char *		charset;
	int		content_length;
	int		flags;
#define XoHINF_F_KEEP_ALIVE	0x00000001
#define XoHINF_F_CHUNKED	0x00000002
#define XoHINF_F_CACHE_OFF	0x00000004
} HTTP_INFO;


typedef struct XLoHTTP_header {
	unsigned char		type;
#define XoH_T_OPEN		1
#define XoH_T_DATA		2
#define XoH_T_LAST		3
#define XoH_T_ERROR		4
#define XoH_T_KEEP_ALIVE	5
#define XoH_T_TESTING_VER	6
#define XoH_T_UPLOAD_SESSION	7
#define XoH_T_DOWNLOAD_SESSION	8
	unsigned char		sum;
	short			seq;
	unsigned int		cockie[2];
} XLoHTTP_HEADER;

typedef struct XoH_list {
	struct XoH_list *	next;
	STREAM *		con;
	XLoHTTP_HEADER		h;
	HTTP_INFO		info;
	unsigned int		tim;
} XoH_LIST;


typedef struct http_agent_list {
	struct http_agent_list *	next;
	char *				path;
	struct http_agent_list *	alias_root;
	struct http_agent_list *	alias_list;
	struct http_agent_list *	alias_list_next;
	int				iid;
	XLISP_ENV *			env;
	L_CHAR *			remote_url;
	XL_SEXP *			initialize;
	int				access_tid;
} HTTP_AGENT_LIST;

int scan_HTTP(HTTP_INFO * info,STREAM * con,int flag);
void free_HTTP_info(HTTP_INFO *);
int new_accept(STREAM **,ACCESS_KEY *,XL_INTERPRETER *,PERMISSION_LIST *);
int XoH_checksum(XLoHTTP_HEADER * h);

void chunk_read_start(STREAM * s);
void chunk_read_end(STREAM * s);
int s_chunk_read(STREAM * s,void * data,int len);
void change_endian_XLoHTTP_HEADER(XLoHTTP_HEADER * h);
void s_close_XLoHTTP_func(STREAM * s);
void s_safe_close(STREAM * s);
void free_con_list(S_XLoHTTP_INFO * info);
void output_client_header(STREAM * con,int flags,char * server,int port,int length);
void open_timeout(STREAM * con);
int __s_flush_XLoHTTP(STREAM * s,S_XLoHTTP_INFO * s_info,
	unsigned char type,int zero_check);
void XLoHTTP_tick_func(S_XLoHTTP_INFO * info);
int new_accept(
	STREAM ** new_st,
	ACCESS_KEY * key,
	XL_INTERPRETER * xli,
	PERMISSION_LIST * pl);
void init_XLoHTTP_server();

int new_accept_2(STREAM ** new_st,ACCESS_KEY * k);
int new_upload_session(XoH_LIST * lst);
void _new_cockie(unsigned int * cockie);
int output_server_header(STREAM * s,HTTP_INFO * info);
int exec_url(HTTP_INFO *,STREAM * st);
HTTP_AGENT_LIST *
insert_http_agent_list(
	char * path,
	XLISP_ENV * env,
	L_CHAR* remote_url,
	HTTP_AGENT_LIST * alias,
	XL_SEXP * initialize);
HTTP_AGENT_LIST * 
search_http_agent_list(char *path);
void initialize_remote(HTTP_AGENT_LIST * a);
void init_http_agent();
void gc_http_agent();



#endif

