/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___ASSOCIATE64_H___
#define ___ASSOCIATE64_H___

#include	"pdb64.h"

#define FAT_ASSOC_INTEGER	0x100
#define FAT_ASSOC_STRING	0x102

#define ASSOC_KEY_NO		10

typedef struct acc64_pn_assoc_header {
	ACC64_HEADER		a;
	PN64_ASSOC_HEADER		d;
} ACC64_PN_ASSOC_HEADER;

typedef struct acc64_pn_assoc_data {
	ACC64_HEADER		a;
	PN64_ASSOC_DATA		d;
} ACC64_PN_ASSOC_DATA;


typedef struct acc64_pn_file_header {
	ACC64_HEADER		a;
	PN64_FILE_HEADER		d;
} ACC64_PN_FILE_HEADER;

typedef struct assoc64_key {
	PDB64 *			p;
	ACC64_PN_FILE_HEADER *	fheader;
	ACC64_PN_ASSOC_HEADER *	assoc;
	int			assoc_len;
} ASSOC64_KEY;

typedef struct assoc64_integer {
	int			data;
	INTEGER64		fofs;
} ASSOC64_INTEGER;

typedef struct assoc64_string_opt {
	int			flags;
	int			size;
} ASSOC64_STRING_OPT;

int
open_associate64(
	char * filename,
	int oflags,
	int mode,
	int flags,
	int type,
	char * encoding);
int insert_associate64(int key,int index,void * from,XL_SEXP * data);
XL_SEXP * search_associate64(int key,int index,void * from,void * opt);
int get_index64(int key,short name);
int new_index64(int key,short type,short name);
int get_index_type64(int key,int index);
XL_SEXP * get_assoc64_all(int key,int index);

#endif

