/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___REGULAR_H___
#define ___REGULAR_H___

#include	"long_char.h"

typedef struct a_goto {
	_L_CHAR			from;
	_L_CHAR			to;
	struct a_state *	next_state;
} A_GOTO;

typedef struct a_state {
	struct a_state *	next;
	int			flags;
#define AF_INIT		0x00000001
#define AF_ACCEPT	0x00000002
#define AF_CHECK1	0x00000004
#define AF_CHECK2	0x00000008
	int			table_size;
	A_GOTO *		table;

	struct a_state *	work_state;
	struct a_state_set *	state_set;
} A_STATE;


typedef struct a_state_set {
	A_STATE *		state;
	struct a_state_set *	next;
} A_STATE_SET;

typedef struct automaton {
	A_STATE *		state_list;
} AUTOMATON;

A_STATE * search_state(AUTOMATON * a,int flags);
A_STATE * get_next_state(A_STATE * s,_L_CHAR ch);

AUTOMATON * get_fa(L_CHAR * str);
int parse_dfa_str(
	int * min_ptr,
	int * max_ptr,
	AUTOMATON * dfa,
	L_CHAR * str,
	int min_match_flag);
int skip_punc(L_CHAR * rex,int * ip,L_CHAR ch1,L_CHAR ch2);
void print_ss(A_STATE_SET * ss);
void print_automaton(AUTOMATON * a);
AUTOMATON * new_automaton();
A_STATE_SET * new_state_set(A_STATE * s);
void free_state_set(A_STATE_SET * ss);
A_STATE * new_state(AUTOMATON * a);
AUTOMATON * copy_automaton(AUTOMATON * a);
void set_goto(A_STATE * s1,L_CHAR from,L_CHAR to,A_STATE * s2);
void marge_automaton(AUTOMATON * a1,AUTOMATON * a2);
void free_automaton(AUTOMATON * a);
void init_flags(AUTOMATON *nfa,A_STATE_SET * ss);
A_STATE_SET * get_state_set(AUTOMATON * nfa,int flags);
A_STATE_SET * get_empty_closure(AUTOMATON * nfa,A_STATE_SET * ss);
A_STATE_SET * get_goto(AUTOMATON * nfa,A_STATE_SET * ss,_L_CHAR from,_L_CHAR to);
_L_CHAR get_from(AUTOMATON * nfa,_L_CHAR to);
A_STATE * exist_check(AUTOMATON * a,A_STATE_SET * ss);
AUTOMATON * get_dfa(AUTOMATON * nfa);




#endif


