/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___STREAM_H___
#define ___STREAM_H___

#ifdef VA2
#include	<varargs.h>
#else
#include	<stdarg.h>
#endif

#include	"machine/include.h"
#include	"u_history.h"
#include	"long_char.h"

#define CLOSE_ZONBIE	10000
#define INITIAL_INTERVAL	10
#define INITIAL_THPUT		1000

#define XLoHTTP_POLLING_MAX	15

typedef struct sbuf_data {
	struct sbuf_data *	next;
	int			ptr;
	int			len;
} SBUF_DATA;

typedef struct stream_buf {
	SBUF_DATA *		head;
	SBUF_DATA *		tail;
} STREAM_BUF;

typedef struct s_dummy {
	char	a;
	char	b;
} S_DUMMY;

typedef struct s_table {
	char		type;
	char		flags;
#define STF_BUF_OUT	0x08
	S_DUMMY		dm;
	struct s_table * next;
	union stream *	(*open_desc)();
	int		(*close)();
	int		(*write)();
	int		(*read)();
	int		(*flush)();
	int		(*proc_send)();
	union stream *	(*proc_recv)();
	int		(*get_socketip)();
	int		(*checksum)();
} S_TABLE;



/* checksum command */
#define S_CK_CLOSE	1
#define S_CK_LEV	5

typedef struct s_checksum_type {
	short		lev_mask;
	char		s_type;
	int *		u_history[S_CK_LEV];
	unsigned int	w_checksum[S_CK_LEV];
} S_CHECKSUM_TYPE;

typedef struct s_file_thread {
	struct s_file_thread *	next;
	int			tid;
} S_FILE_THREAD;

typedef struct s_header {
	S_TABLE *	tbl;
	int		mode;
	char		stream_type;
#define STT_UNKNOWN	0x01
#define STT_FILE	0x02
#define STT_NET		0x04
#define STT_STD		0x08
#define STT_OTHERS	0x10
	char		wb_flags;
#define WBF_WRITING	0x01
#define WBF_C_TIMEOUT	0x02
#define WBF_ERROR	0x04

#define WBF_MASK	(WBF_WRITING|WBF_C_TIMEOUT|WBF_ERROR)
	char		cr_mode;
#define CRM_NOTCOUNT	0
#define CRM_COUNT	1
	int		cr_cnt;
	CODE_METHOD *	cm;
	void *		cm_work;
	S_FILE_THREAD *	thread;
	
	int		write_abort_type;
#define WAT_CLOSE	1
#define WAT_SIGNAL	2
	int		write_abort_interval;
#define WAT_DEFAULT_INTERVAL	10
	INTEGER64	write_in_time;
	int		write_tid;

	STREAM_BUF	write_buf;

	union stream * 	next;
	int		last_size;
	int		last_err;

	unsigned int	last_time;
	int		interval;
	int		bytes_per_interval;
	int		avg_thput;	// byte / sec
	int		usec_per_byte;

	char		pushed;
	char		pushed_flag;

	struct s_header * check_ptr;
	unsigned int	close_time;
	unsigned int	zonbie_access;

	unsigned int	create_time;
	char *		create_file;
	int		create_line;

	unsigned int	w_checksum;
	U_HISTORY	u_history;
} S_HEADER;

typedef struct s_string {
	S_HEADER	h;
	char *		str;
	char *		ptr;
	int		size;
	int		flag;
} S_STRING;

#define CHAIN_BUF_SIZE	4096

typedef struct s_chain {
	S_HEADER	h;
	int		iid;
	char		process;
	char		write_process;
	char		type[2];
	/* 'o' : stdio , 'e' stderr */
	short		buf_len;
	char		buf[CHAIN_BUF_SIZE];
} S_CHAIN;

typedef struct XoH_request {
	struct XoH_request *	next;
	union stream *		con;
	short			seq;
} XoH_REQUEST;

typedef struct s_XLoHTTP_info {
	union stream *	st;
	XoH_REQUEST *	con_head;
	XoH_REQUEST *	con_tail;
	union stream *	keep_con;
	int		flags;
#define XoH_F_RECV_LAST		0x00000001
#define XoH_F_ERR		0x00000002
#define XoH_F_CLOSE		0x00010000
#define XoH_F_TASK_CLOSE	0x00020000
#define XoH_F_FLUSH		0x00000100
#define XoH_F_PROXY		0x00000010
#define XoH_F_KEEP_ALIVE	0x00000020
#define XoH_F_CHUNKED		0x00000040

#define XoH_F_MASK		0x00000060
	char *		target_server;
	int		target_ip;
	unsigned short	target_port;

	char *		proxy_server;
	int		proxy_ip;
	unsigned short	proxy_port;

	short		send_seq;
	short		recv_seq;
	unsigned int	cockie[2];
	STREAM_BUF	send;
	STREAM_BUF	recv;
	unsigned int	last_polling_time;
	int		polling_interval;
	union stream *	target_con;
} S_XLoHTTP_INFO;

typedef struct s_XLoHTTP {
	S_HEADER		h;
	S_XLoHTTP_INFO *	info;
} S_XLoHTTP;


typedef struct s_XLoHTTP_info_2 {
	int			flags;
#define XoH_F2_BUFFER			0x00000001
#define XoH_F2_CLOSE		0x00000002
	char *			proxy_server;
	unsigned int		proxy_ip;
	int			proxy_port;

	char *			target_server;
	unsigned int		target_ip;
	int			target_port;
	unsigned int		cockie[2];
	int			remain_size;
#define MAX_REMAIN_SIZE			100000000
	union stream *		upload_st;
	union stream *		download_st;
	STREAM_BUF		upload_buf;
} S_XLoHTTP_INFO_2;

typedef struct s_XLoHTTP_2 {
	S_HEADER		h;
	S_XLoHTTP_INFO_2 *	info;
} S_XLoHTTP_2;

/*
#ifdef WITH_OSSL
*/
#include "openssl/ssl.h"
typedef struct s_OSSL{
	S_HEADER		h;
	SSL *ssl;
	unsigned char is_error;
} S_OSSL;
/*
#endif 
*/

#include	"machine/stream.h"

extern S_FILE __s_std[3];

/*
#define s_stdin		((STREAM*)&__s_std[0])
#define s_stdout	((STREAM*)&__s_std[1])
#define s_stderr	((STREAM*)&__s_std[2])
*/
extern STREAM * s_stdin,* s_stdout,* s_stderr;

#ifdef LIBRARY
STREAM * s_open_file(char *,int,int);
#else
STREAM * s_open_file(char *,int,...);
#endif
STREAM * s_open_terminal(int (*)());
STREAM * s_open_string_read(void *,CODE_METHOD *,int,int);
STREAM * s_open_string_write(CODE_METHOD *);
STREAM * s_connect_XLoHTTP(
	int * cerr,
	char * target_server,int target_ip,short target_port,
	char * proxy_server,int proxy_ip,short proxy_port,
	int flags);
STREAM * s_connect_XLoHTTP_2(
	int * cerr,
	char * target_server,int target_ip,short target_port,
	char * proxy_server,int proxy_ip,short proxy_port,
	int flags);

void init_stream();
void xx_s_open(STREAM *,int,int,char*,int);
#define s_open(s,m,stt)	xx_s_open(s,m,stt,__FILE__,__LINE__)
void _xx_s_open(STREAM *,int,int,char*,int);
#define _s_open(s,m,stt)	_xx_s_open(s,m,stt,__FILE__,__LINE__)
/*
int s_close(STREAM *);
*/

int __d_s_close(STREAM *,char *,int);
#define _s_close(st)	__d_s_close(st,__FILE__,__LINE__)

int _d_s_close(STREAM *,char *,int);
#define s_close(st)	_d_s_close(st,__FILE__,__LINE__)

int s_write(STREAM *,void *,int);
int s_read(STREAM *,void *,int);
int s_printf(STREAM *,char *,...);
int s_flush(STREAM *);
int s_push(STREAM *,char);
int _s_printf(STREAM*,int*,char*,va_list);
int ss_printf(char *,...);
int ss_sprintf(L_CHAR *,char*,...);
int e_printf(STREAM*,int*,char *,...);

void s_set_cr(STREAM *,int);
void s_reset_cr(STREAM *);
void s_set_cm(STREAM *,CODE_METHOD *);
CODE_METHOD * s_get_cm(STREAM*);
int s_type(STREAM *);
STREAM * s_open_descripter(int,S_TABLE *);
int s_get_socketip(STREAM * s);
char * s_get_string(STREAM * st);
L_CHAR * s_get_l_string(STREAM * st);
int s_seek_file(STREAM * s,unsigned int,int);
int s_check_resource2(int *);
int s_exist(STREAM *);

STREAM * s_open_chain(int,char);
STREAM * s_get_chain_from_iid(int iid);

int s_open_pipe(STREAM * p[2]);
int s_open_fpipe(STREAM * p[2]);
int s_wait_flush_fpipe(STREAM *);
int s_get_fpipe_data_size(STREAM *);
int s_set_fpipe_ip_addr(STREAM * s,int ip);

int s_copy_to_stream(int *,STREAM *,STREAM *,int);
#define S_COPY_TO_STREAM_SRC_ERR	(-1)
#define S_COPY_TO_STREAM_DEST_ERR	(-2)

extern void (*stream_gc)();

int s_get_thput(STREAM *);

void _s_close_sync(STREAM * s);
void _s_insert_thread(STREAM * s,S_FILE_THREAD * t);
void _s_delete_thread(STREAM * s,S_FILE_THREAD * t);
void s_delete_thread(STREAM * s,S_FILE_THREAD * t);
void insert_s_table(S_TABLE * tbl);

void proc_recv_stream(char * msg);

void init_chain_stream();
void _delete_stream_list(STREAM * s,char * file,int line);
int s_error();
STREAM * s_error_stream();
int _s_exist(STREAM * s);
void thput_task();
void init_machine_stream();
void init_string_stream();
void init_XLoHTTP_stream();
int s_stream_nos();
int _s_write(STREAM * s);
void s_write_task();
void s_write_tick();
int s_check_resource();

void init_file_stream();
void init_flush_pipe_stream();
void init_terminal_stream();
int s_set_prompt(STREAM * s,int (*prompt)());

void s_close_queue(STREAM * st);
void
s_set_write_abort(STREAM * s,int type,int interval);


int s_check_resource3();
void
calc_checksum(STREAM * s,void * data,int len,int fags);

void
s_shutdown_stream(int flags);

extern int shutdown_stream_flags;


#endif
