/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"lc_encode.h"
#include	"tr_html.h"

XL_SEXP * html_center();

void
init_html_center(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"CENTER"),
		get_func_prim(html_center,FO_NORMAL,0,1,-1));
}

XL_SEXP *
html_center(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
TR_HTML_INFO * inf;
XL_SEXP * ret;
L_CHAR ch;
TR_LINE_ATTR attr;
	inf = tr_get_html_info(env);
	if ( inf->d.last_output != '\n' ) {
		ch = '\n';
		tr_html_string_data(inf,&ch,1);
	}
	tr_push_attr_stack(inf);
	attr.flags = TRLF_ALIGN;
	attr.align = TRT_CENTER;
	_tr_set_line_attr(&attr,&inf->d.attr_stack->attr);
	if ( inf->d.last_output != '\n' ) {
		ch = '\n';
		tr_html_string_data(inf,&ch,1);
	}
	ret = tr_html_pair_non_symbol(inf,cdr(s));
	tr_pop_attr_stack(inf);
	return ret;
}


